/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.api.monitor;

import io.gravitee.node.api.monitor.JvmInfo;
import io.gravitee.node.api.monitor.OsInfo;
import io.gravitee.node.api.monitor.ProcessInfo;
import io.gravitee.reporter.api.Reportable;
import java.io.Serializable;
import java.time.Instant;

public class Monitor
implements Serializable,
Reportable {
    private String nodeId;
    private long timestamp;
    JvmInfo jvm;
    OsInfo os;
    ProcessInfo process;

    protected Monitor() {
    }

    public Monitor(String nodeId, long timestamp) {
        this.nodeId = nodeId;
        this.timestamp = timestamp;
    }

    public Instant timestamp() {
        return Instant.ofEpochMilli(this.timestamp);
    }

    public JvmInfo getJvm() {
        return this.jvm;
    }

    public OsInfo getOs() {
        return this.os;
    }

    public ProcessInfo getProcess() {
        return this.process;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public static Builder on(String nodeId) {
        return new Builder().on(nodeId);
    }

    public static class Builder {
        private String nodeId;
        private long timestamp;
        private OsInfo os;
        private JvmInfo jvm;
        private ProcessInfo process;

        public Builder on(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public Builder at(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder os(OsInfo os) {
            this.os = os;
            return this;
        }

        public Builder jvm(JvmInfo jvm) {
            this.jvm = jvm;
            return this;
        }

        public Builder process(ProcessInfo process) {
            this.process = process;
            return this;
        }

        public Monitor build() {
            Monitor metrics = new Monitor(this.nodeId, this.timestamp);
            metrics.os = this.os;
            metrics.jvm = this.jvm;
            metrics.process = this.process;
            return metrics;
        }
    }
}

