/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.standalone.jetty;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.rest.api.management.rest.resource.GraviteeManagementApplication;
import io.gravitee.rest.api.management.security.SecurityManagementConfiguration;
import io.gravitee.rest.api.management.v2.rest.GraviteeManagementV2Application;
import io.gravitee.rest.api.management.v2.security.SecurityManagementV2Configuration;
import io.gravitee.rest.api.portal.rest.resource.GraviteePortalApplication;
import io.gravitee.rest.api.portal.security.SecurityPortalConfiguration;
import io.gravitee.rest.api.standalone.jetty.JettyServerFactory;
import io.gravitee.rest.api.standalone.jetty.handler.NoContentOutputErrorHandler;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventListener;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.security.config.annotation.authentication.configuration.GlobalAuthenticationConfigurerAdapter;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.filter.DelegatingFilterProxy;

public final class JettyEmbeddedContainer
extends AbstractLifecycleComponent<JettyEmbeddedContainer>
implements ApplicationContextAware {
    @Autowired
    private JettyServerFactory jettyServerFactory;
    private Server server;
    private ApplicationContext applicationContext;
    @Value(value="${http.api.management.enabled:true}")
    private boolean startManagementAPI;
    @Value(value="${http.api.management.entrypoint:${http.api.entrypoint:/}management}")
    private String managementEntrypoint;
    @Value(value="${http.api.portal.enabled:true}")
    private boolean startPortalAPI;
    @Value(value="${http.api.portal.entrypoint:${http.api.entrypoint:/}portal}")
    private String portalEntrypoint;

    protected void doStart() throws Exception {
        this.server = this.jettyServerFactory.getObject();
        NoContentOutputErrorHandler noContentHandler = new NoContentOutputErrorHandler();
        noContentHandler.setServer(this.server);
        this.server.addBean((Object)noContentHandler);
        System.setProperty("spring.profiles.active", "basic");
        ArrayList<ServletContextHandler> contexts = new ArrayList<ServletContextHandler>();
        if (this.startPortalAPI) {
            ServletContextHandler portalContextHandler = this.configureAPI(this.portalEntrypoint, GraviteePortalApplication.class.getName(), SecurityPortalConfiguration.class);
            contexts.add(portalContextHandler);
        }
        if (this.startManagementAPI) {
            ServletContextHandler managementContextHandler = this.configureAPI(this.managementEntrypoint, GraviteeManagementApplication.class.getName(), SecurityManagementConfiguration.class);
            contexts.add(managementContextHandler);
            ServletContextHandler managementV2ContextHandler = this.configureAPI(this.managementEntrypoint + "/v2", GraviteeManagementV2Application.class.getName(), SecurityManagementV2Configuration.class);
            contexts.add(managementV2ContextHandler);
        }
        if (contexts.isEmpty()) {
            throw new IllegalStateException("At least one API should be enabled");
        }
        this.server.setHandler((Handler)new ContextHandlerCollection((ContextHandler[])contexts.toArray(new ServletContextHandler[contexts.size()])));
        this.server.start();
    }

    protected ServletContextHandler configureAPI(String apiContextPath, String applicationName, Class<? extends GlobalAuthenticationConfigurerAdapter> securityConfigurationClass) {
        ServletContextHandler childContext = new ServletContextHandler((HandlerContainer)this.server, apiContextPath, 1);
        ServletHolder servletHolder = new ServletHolder(ServletContainer.class);
        servletHolder.setInitParameter("jakarta.ws.rs.Application", applicationName);
        servletHolder.setInitOrder(0);
        childContext.addServlet(servletHolder, "/*");
        AnnotationConfigWebApplicationContext webApplicationContext = new AnnotationConfigWebApplicationContext();
        webApplicationContext.register(new Class[]{securityConfigurationClass});
        webApplicationContext.setEnvironment((ConfigurableEnvironment)this.applicationContext.getEnvironment());
        webApplicationContext.setParent(this.applicationContext);
        childContext.addEventListener((EventListener)new ContextLoaderListener((WebApplicationContext)webApplicationContext));
        childContext.addFilter(new FilterHolder((Filter)new DelegatingFilterProxy("springSecurityFilterChain")), "/*", EnumSet.allOf(DispatcherType.class));
        return childContext;
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

