/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.standalone.boostrap;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class Bootstrap {
    private static final String GRAVITEE_HOME_PROP = "gravitee.home";
    private static final String CONTAINER_CLASS = "io.gravitee.rest.api.standalone.GraviteeApisContainer";
    private static final String LIB_DIRECTORY = "lib";
    private static final String LIB_EXT_DIRECTORY = "lib" + File.separatorChar + "ext";
    private ClassLoader graviteeClassLoader;
    private ClassLoader extensionClassLoader;
    private Object graviteeDaemon = null;

    private Bootstrap() {
    }

    public void init() throws Exception {
        this.setGraviteeHome();
        this.initClassLoaders();
        Thread.currentThread().setContextClassLoader(this.graviteeClassLoader);
        Class<?> fwClass = this.graviteeClassLoader.loadClass(CONTAINER_CLASS);
        this.graviteeDaemon = fwClass.newInstance();
    }

    private void initClassLoaders() {
        this.createExtensionClassLoader();
        this.createGraviteeClassLoader();
    }

    private void createGraviteeClassLoader() {
        ArrayList<URL> cpList = new ArrayList<URL>();
        URL[] cpURLs = new URL[]{};
        File libDir = new File(System.getProperty(GRAVITEE_HOME_PROP), LIB_DIRECTORY);
        for (File lib : libDir.listFiles()) {
            try {
                cpList.add(lib.toURI().toURL());
            }
            catch (MalformedURLException urlEx) {
                urlEx.printStackTrace();
            }
        }
        cpURLs = cpList.toArray(cpURLs);
        this.graviteeClassLoader = new URLClassLoader(cpURLs, this.extensionClassLoader);
    }

    private void createExtensionClassLoader() {
        ArrayList<URL> cpList = new ArrayList<URL>();
        URL[] cpURLs = new URL[]{};
        File libDir = new File(System.getProperty(GRAVITEE_HOME_PROP), LIB_EXT_DIRECTORY);
        if (libDir.exists() || libDir.isDirectory()) {
            try {
                cpList.add(libDir.toURI().toURL());
                for (File lib : libDir.listFiles()) {
                    cpList.add(lib.toURI().toURL());
                }
            }
            catch (MalformedURLException urlEx) {
                urlEx.printStackTrace();
            }
        }
        cpURLs = cpList.toArray(cpURLs);
        this.extensionClassLoader = new URLClassLoader(cpURLs, this.getClass().getClassLoader());
    }

    private void setGraviteeHome() {
        String installPath = System.getProperty(GRAVITEE_HOME_PROP);
        if (installPath == null) {
            File installDir = new File(System.getProperty("user.dir"));
            if (LIB_DIRECTORY.equals(installDir.getName())) {
                installDir = installDir.getParentFile();
            }
            installPath = installDir.getAbsolutePath();
        }
        File graviteeHomeDir = new File(installPath);
        this.checkInstallRoot(graviteeHomeDir);
        System.setProperty(GRAVITEE_HOME_PROP, graviteeHomeDir.getAbsolutePath());
    }

    private void checkInstallRoot(File graviteeHomeDir) {
        if (!graviteeHomeDir.isDirectory()) {
            throw new RuntimeException("Invalid Gravitee.io Node home directory. Not a directory: " + graviteeHomeDir.getAbsolutePath());
        }
        File graviteeLibDir = new File(graviteeHomeDir, LIB_DIRECTORY);
        File[] files = graviteeLibDir.listFiles(pathname -> pathname.getName().startsWith("gravitee-apim-rest-api-standalone-bootstrap"));
        if (files == null || files.length == 0 || files.length > 1) {
            throw new RuntimeException("Invalid Gravitee.io Node home directory. No bootstrapable jar can be found in " + graviteeLibDir.getAbsolutePath());
        }
    }

    public void start() throws Exception {
        if (this.graviteeDaemon == null) {
            this.init();
        }
        Method method = this.graviteeDaemon.getClass().getMethod("start", null);
        method.invoke(this.graviteeDaemon, (Object[])null);
    }

    public static void main(String[] args) {
        Thread mainThread = Thread.currentThread();
        mainThread.setName("graviteeio-node");
        try {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.start();
        }
        catch (Exception t) {
            t.printStackTrace();
            System.exit(1);
        }
    }
}

