/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import io.gravitee.common.event.EventManager;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.service.event.ApiEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiManager.class);
    private final Map<String, Api> apis = new HashMap<String, Api>();
    @Autowired
    private EventManager eventManager;

    public void deploy(Api api) {
        log.info("Deployment of API id[{}] name[{}] version[{}]", new Object[]{api.getId(), api.getName(), api.getVersion()});
        this.apis.put(api.getId(), api);
        if (api.getLifecycleState() == LifecycleState.STARTED) {
            this.eventManager.publishEvent((Enum)ApiEvent.DEPLOY, (Object)api);
        } else {
            log.debug("API id[{}] name[{}] version[{}] is not enabled. Skip deployment.", new Object[]{api.getId(), api.getName(), api.getVersion()});
        }
    }

    public void update(Api api) {
        this.apis.put(api.getId(), api);
        this.eventManager.publishEvent((Enum)ApiEvent.UPDATE, (Object)api);
    }

    public void undeploy(String apiId) {
        Api currentApi = this.apis.remove(apiId);
        if (currentApi != null) {
            log.info("Un-deploying API id[{}] name[{}] version[{}]", new Object[]{currentApi.getId(), currentApi.getName(), currentApi.getVersion()});
            this.eventManager.publishEvent((Enum)ApiEvent.UNDEPLOY, (Object)currentApi);
            log.info("API id[{}] has been un-deployed", (Object)apiId);
        }
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public Collection<Api> apis() {
        return this.apis.values();
    }

    public Api get(String name) {
        return this.apis.get(name);
    }
}

