/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.data.domain.Page;
import io.gravitee.node.api.license.License;
import io.gravitee.node.api.license.LicenseFactory;
import io.gravitee.node.api.license.LicenseManager;
import io.gravitee.repository.exceptions.TechnicalException;
import io.gravitee.repository.management.api.EventLatestRepository;
import io.gravitee.repository.management.api.LicenseRepository;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.LicenseCriteria;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.License;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.converter.ApiConverter;
import io.gravitee.rest.api.service.v4.PrimaryOwnerService;
import io.gravitee.rest.api.service.v4.mapper.ApiMapper;
import io.gravitee.rest.api.services.sync.ApiManager;
import io.gravitee.rest.api.services.sync.DictionaryManager;
import java.time.Instant;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

public class SyncManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncManager.class);
    private static final int TIMEFRAME_BEFORE_DELAY = 600000;
    private static final int TIMEFRAME_AFTER_DELAY = 60000;
    private final AtomicLong counter = new AtomicLong(0L);
    @Autowired
    private DictionaryManager dictionaryManager;
    @Lazy
    @Autowired
    private EventLatestRepository eventLatestRepository;
    @Lazy
    @Autowired
    private LicenseRepository licenseRepository;
    @Autowired
    private ApiManager apiManager;
    @Autowired
    private ApiConverter apiConverter;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private PrimaryOwnerService primaryOwnerService;
    @Autowired
    private ApiMapper apiMapper;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private LicenseFactory licenseFactory;
    private long lastRefreshAt = -1L;

    public void refresh() {
        log.debug("Synchronization #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now());
        log.debug("Refreshing state...");
        long nextLastRefreshAt = System.currentTimeMillis();
        try {
            this.synchronizeLicenses(nextLastRefreshAt);
        }
        catch (Exception ex) {
            log.error("An error occurs while synchronizing licenses", (Throwable)ex);
        }
        try {
            this.synchronizeApis(nextLastRefreshAt);
        }
        catch (Exception ex) {
            log.error("An error occurs while synchronizing APIs", (Throwable)ex);
        }
        try {
            this.synchronizeDictionaries(nextLastRefreshAt);
        }
        catch (Exception ex) {
            log.error("An error occurs while synchronizing dictionaries", (Throwable)ex);
        }
        this.lastRefreshAt = nextLastRefreshAt;
        log.debug("Synchronization #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now());
    }

    private void synchronizeApis(long nextLastRefreshAt) {
        EventCriteria eventCriteria = EventCriteria.builder().types(Set.of(EventType.PUBLISH_API, EventType.UNPUBLISH_API, EventType.START_API, EventType.STOP_API)).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L).build();
        Map<String, Event> apiEvents = this.eventLatestRepository.search(eventCriteria, Event.EventProperties.API_ID, null, null).stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.API_ID.getValue()), event -> event));
        this.computeApiEvents(apiEvents);
    }

    private void synchronizeDictionaries(long nextLastRefreshAt) throws Exception {
        EventCriteria eventCriteria = EventCriteria.builder().types(Set.of(EventType.START_DICTIONARY, EventType.STOP_DICTIONARY)).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L).build();
        Map<String, Event> dictionaryEvents = this.eventLatestRepository.search(eventCriteria, Event.EventProperties.DICTIONARY_ID, null, null).stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.DICTIONARY_ID.getValue()), event -> event));
        this.computeDictionaryEvents(dictionaryEvents);
    }

    private void synchronizeLicenses(long nextLastRefreshAt) throws TechnicalException {
        LicenseCriteria licenseCriteria = LicenseCriteria.builder().referenceType(License.ReferenceType.ORGANIZATION).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L).build();
        Page licenses = this.licenseRepository.findByCriteria(licenseCriteria, null);
        licenses.getContent().forEach(license -> {
            try {
                License orgLicense = this.licenseFactory.create("ORGANIZATION", license.getReferenceId(), license.getLicense());
                this.licenseManager.registerOrganizationLicense(license.getReferenceId(), orgLicense);
            }
            catch (Exception e) {
                log.warn("Organization license cannot be registered for [{}].", (Object)license.getReferenceId(), (Object)e);
            }
        });
    }

    private void computeDictionaryEvents(Map<String, Event> dictionaryEvents) {
        dictionaryEvents.forEach((id, event) -> {
            switch (event.getType()) {
                case START_DICTIONARY: {
                    this.dictionaryManager.start((String)id);
                    break;
                }
                case STOP_DICTIONARY: {
                    this.dictionaryManager.stop((String)id);
                    break;
                }
            }
        });
    }

    private void computeApiEvents(Map<String, Event> apiEvents) {
        int parallelism = Runtime.getRuntime().availableProcessors() * 2;
        if (apiEvents.size() > parallelism) {
            ForkJoinPool.ForkJoinWorkerThreadFactory factory = pool -> {
                ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
                worker.setName("gio.sync-" + worker.getPoolIndex());
                return worker;
            };
            ForkJoinPool customThreadPool = new ForkJoinPool(parallelism, factory, null, false);
            customThreadPool.submit(() -> apiEvents.entrySet().parallelStream().forEach(e -> this.processApiEvent((String)e.getKey(), (Event)e.getValue())));
            customThreadPool.shutdown();
        } else {
            apiEvents.forEach(this::processApiEvent);
        }
    }

    protected void processApiEvent(String apiId, Event apiEvent) {
        switch (apiEvent.getType()) {
            case UNPUBLISH_API: 
            case STOP_API: {
                this.apiManager.undeploy(apiId);
                break;
            }
            case START_API: 
            case PUBLISH_API: {
                try {
                    Api apiToDeploy = (Api)this.objectMapper.readValue(apiEvent.getPayload(), Api.class);
                    if (apiToDeploy == null) break;
                    Api deployedApi = this.apiManager.get(apiToDeploy.getId());
                    if (deployedApi == null) {
                        this.apiManager.deploy(apiToDeploy);
                        break;
                    }
                    if (!deployedApi.getDeployedAt().before(apiToDeploy.getDeployedAt())) break;
                    this.apiManager.update(apiToDeploy);
                }
                catch (Exception e) {
                    log.error("Unable to handle event [" + apiEvent.getType() + "]  for API [" + apiId + "]", (Throwable)e);
                }
                break;
            }
        }
    }
}

