/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import io.gravitee.common.event.EventManager;
import io.gravitee.rest.api.model.configuration.dictionary.DictionaryEntity;
import io.gravitee.rest.api.service.configuration.dictionary.DictionaryService;
import io.gravitee.rest.api.service.event.DictionaryEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DictionaryManager {
    private final Logger logger = LoggerFactory.getLogger(DictionaryManager.class);
    @Autowired
    private DictionaryService dictionaryService;
    @Autowired
    private EventManager eventManager;
    private final Map<String, DictionaryEntity> dictionaries = new HashMap<String, DictionaryEntity>();

    public void start(String dictionaryId) {
        try {
            DictionaryEntity dictionary = this.dictionaryService.findById(dictionaryId);
            DictionaryEntity startedDictionary = this.dictionaries.get(dictionary.getId());
            if (startedDictionary == null) {
                this.eventManager.publishEvent((Enum)DictionaryEvent.START, (Object)dictionary);
            } else if (this.needRestart(dictionary, startedDictionary)) {
                this.eventManager.publishEvent((Enum)DictionaryEvent.RESTART, (Object)dictionary);
            }
            this.dictionaries.put(dictionary.getId(), dictionary);
        }
        catch (Exception e) {
            this.logger.error("Error occurred when trying to start the dictionary [{}].", (Object)dictionaryId, (Object)e);
        }
    }

    public void stop(String dictionaryId) {
        try {
            DictionaryEntity dictionary = new DictionaryEntity();
            dictionary.setId(dictionaryId);
            this.eventManager.publishEvent((Enum)DictionaryEvent.STOP, (Object)dictionary);
            this.dictionaries.remove(dictionaryId);
        }
        catch (Exception e) {
            this.logger.error("Error occurred when trying to stop the dictionary [{}].", (Object)dictionaryId, (Object)e);
        }
    }

    private boolean needRestart(DictionaryEntity dictionary, DictionaryEntity startedDictionary) {
        return dictionary.getUpdatedAt() != null && dictionary.getUpdatedAt().after(startedDictionary.getUpdatedAt()) && (!Objects.equals(dictionary.getProvider().getConfiguration(), startedDictionary.getProvider().getConfiguration()) || !Objects.equals(dictionary.getTrigger(), startedDictionary.getTrigger()));
    }
}

