/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.sync;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.event.EventManager;
import io.gravitee.repository.management.api.ApiRepository;
import io.gravitee.repository.management.api.DictionaryRepository;
import io.gravitee.repository.management.api.EventRepository;
import io.gravitee.repository.management.api.search.ApiFieldExclusionFilter;
import io.gravitee.repository.management.api.search.EventCriteria;
import io.gravitee.repository.management.api.search.builder.PageableBuilder;
import io.gravitee.repository.management.model.Api;
import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.DictionaryType;
import io.gravitee.repository.management.model.Event;
import io.gravitee.repository.management.model.EventType;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.rest.api.model.EnvironmentEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.service.ApiService;
import io.gravitee.rest.api.service.EnvironmentService;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.services.sync.ApiManager;
import io.gravitee.rest.api.services.sync.DictionaryManager;
import java.io.IOException;
import java.time.Instant;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyncManager {
    private final Logger logger = LoggerFactory.getLogger(SyncManager.class);
    private static final int TIMEFRAME_BEFORE_DELAY = 600000;
    private static final int TIMEFRAME_AFTER_DELAY = 60000;
    @Autowired
    private ApiRepository apiRepository;
    @Autowired
    private DictionaryManager dictionaryManager;
    @Autowired
    private DictionaryRepository dictionaryRepository;
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private ApiManager apiManager;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private EventManager eventManager;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private UserService userService;
    @Autowired
    private EnvironmentService environmentService;
    @Autowired
    private ApiService apiService;
    private final AtomicLong counter = new AtomicLong(0L);
    private long lastRefreshAt = -1L;

    public void refresh() {
        this.logger.debug("Synchronization #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now());
        this.logger.debug("Refreshing state...");
        long nextLastRefreshAt = System.currentTimeMillis();
        try {
            this.synchronizeApis(nextLastRefreshAt);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while synchronizing APIs", (Throwable)ex);
        }
        try {
            this.synchronizeDictionaries(nextLastRefreshAt);
        }
        catch (Exception ex) {
            this.logger.error("An error occurs while synchronizing dictionaries", (Throwable)ex);
        }
        this.lastRefreshAt = nextLastRefreshAt;
        this.logger.debug("Synchronization #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now());
    }

    private void synchronizeApis(long nextLastRefreshAt) {
        Map<String, Event> apiEvents;
        if (this.lastRefreshAt == -1L) {
            List apis = this.apiRepository.search(null, new ApiFieldExclusionFilter.Builder().excludeDefinition().excludePicture().build());
            apiEvents = apis.stream().map(api -> this.getLastApiEvent(api.getId())).filter(Objects::nonNull).collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.API_ID.getValue()), event -> event));
        } else {
            List<Event> events = this.getLatestApiEvents(nextLastRefreshAt);
            apiEvents = events.stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.API_ID.getValue()), event -> event, BinaryOperator.maxBy(Comparator.comparing(Event::getCreatedAt))));
        }
        this.computeApiEvents(apiEvents);
    }

    private void synchronizeDictionaries(long nextLastRefreshAt) throws Exception {
        Map<String, Event> dictionaryEvents;
        if (this.lastRefreshAt == -1L) {
            List dictionaries = this.dictionaryRepository.findAll().stream().filter(dictionary -> dictionary.getType() == DictionaryType.DYNAMIC).collect(Collectors.toList());
            dictionaryEvents = dictionaries.stream().map(api -> this.getLastDictionaryEvent(api.getId())).filter(Objects::nonNull).collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.DICTIONARY_ID.getValue()), event -> event));
        } else {
            List<Event> events = this.getLatestDictionaryEvents(nextLastRefreshAt);
            dictionaryEvents = events.stream().collect(Collectors.toMap(event -> (String)event.getProperties().get(Event.EventProperties.DICTIONARY_ID.getValue()), event -> event, BinaryOperator.maxBy(Comparator.comparing(Event::getCreatedAt))));
        }
        this.computeDictionaryEvents(dictionaryEvents);
    }

    private void computeDictionaryEvents(Map<String, Event> dictionaryEvents) {
        dictionaryEvents.forEach((id, event) -> {
            switch (event.getType()) {
                case START_DICTIONARY: {
                    this.dictionaryManager.start((String)id);
                    break;
                }
                case STOP_DICTIONARY: {
                    this.dictionaryManager.stop((String)id);
                    break;
                }
            }
        });
    }

    private void computeApiEvents(Map<String, Event> apiEvents) {
        apiEvents.forEach((apiId, apiEvent) -> {
            switch (apiEvent.getType()) {
                case UNPUBLISH_API: 
                case STOP_API: {
                    this.apiManager.undeploy((String)apiId);
                    break;
                }
                case START_API: 
                case PUBLISH_API: {
                    try {
                        Api payloadApi = (Api)this.objectMapper.readValue(apiEvent.getPayload(), Api.class);
                        ApiEntity apiToDeploy = this.convert(payloadApi);
                        if (apiToDeploy == null) break;
                        ApiEntity deployedApi = this.apiManager.get(apiToDeploy.getId());
                        if (deployedApi == null) {
                            this.apiManager.deploy(apiToDeploy);
                            break;
                        }
                        if (!deployedApi.getDeployedAt().before(apiToDeploy.getDeployedAt())) break;
                        this.apiManager.update(apiToDeploy);
                    }
                    catch (Exception e) {
                        this.logger.error("Error while determining deployed APIs store into events payload", (Throwable)e);
                    }
                    break;
                }
            }
        });
    }

    private Event getLastDictionaryEvent(String dictionary) {
        EventCriteria.Builder eventCriteriaBuilder = new EventCriteria.Builder().property(Event.EventProperties.DICTIONARY_ID.getValue(), (Object)dictionary);
        List events = this.eventRepository.search(eventCriteriaBuilder.types(new EventType[]{EventType.START_DICTIONARY, EventType.STOP_DICTIONARY}).build(), new PageableBuilder().pageNumber(0).pageSize(1).build()).getContent();
        return !events.isEmpty() ? (Event)events.get(0) : null;
    }

    private List<Event> getLatestDictionaryEvents(long nextLastRefreshAt) {
        EventCriteria.Builder builder = new EventCriteria.Builder().types(new EventType[]{EventType.START_DICTIONARY, EventType.STOP_DICTIONARY}).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L);
        return this.eventRepository.search(builder.build());
    }

    private List<Event> getLatestApiEvents(long nextLastRefreshAt) {
        EventCriteria.Builder builder = new EventCriteria.Builder().types(new EventType[]{EventType.PUBLISH_API, EventType.UNPUBLISH_API, EventType.START_API, EventType.STOP_API}).from(this.lastRefreshAt - 600000L).to(nextLastRefreshAt + 60000L);
        return this.eventRepository.search(builder.build());
    }

    private Event getLastApiEvent(String api) {
        EventCriteria.Builder eventCriteriaBuilder = new EventCriteria.Builder().property(Event.EventProperties.API_ID.getValue(), (Object)api);
        List events = this.eventRepository.search(eventCriteriaBuilder.types(new EventType[]{EventType.PUBLISH_API, EventType.UNPUBLISH_API, EventType.START_API, EventType.STOP_API}).build(), new PageableBuilder().pageNumber(0).pageSize(1).build()).getContent();
        return !events.isEmpty() ? (Event)events.get(0) : null;
    }

    private ApiEntity convert(Api api) {
        ApiLifecycleState apiLifecycleState;
        ApiEntity apiEntity = new ApiEntity();
        apiEntity.setId(api.getId());
        apiEntity.setName(api.getName());
        apiEntity.setDeployedAt(api.getDeployedAt());
        apiEntity.setCreatedAt(api.getCreatedAt());
        if (api.getDefinition() != null) {
            try {
                io.gravitee.definition.model.Api apiDefinition = (io.gravitee.definition.model.Api)this.objectMapper.readValue(api.getDefinition(), io.gravitee.definition.model.Api.class);
                apiEntity.setProxy(apiDefinition.getProxy());
                apiEntity.setPaths(apiDefinition.getPaths());
                apiEntity.setServices(apiDefinition.getServices());
                apiEntity.setResources(apiDefinition.getResources());
                apiEntity.setProperties(apiDefinition.getProperties());
                apiEntity.setTags(apiDefinition.getTags());
                if (apiDefinition.getPathMappings() != null) {
                    apiEntity.setPathMappings(new HashSet(apiDefinition.getPathMappings().keySet()));
                }
            }
            catch (IOException ioe) {
                this.logger.error("Unexpected error while generating API definition", (Throwable)ioe);
            }
        }
        apiEntity.setUpdatedAt(api.getUpdatedAt());
        apiEntity.setVersion(api.getVersion());
        apiEntity.setDescription(api.getDescription());
        apiEntity.setPicture(api.getPicture());
        apiEntity.setBackground(api.getBackground());
        apiEntity.setCategories(api.getCategories());
        LifecycleState lifecycleState = api.getLifecycleState();
        if (lifecycleState != null) {
            apiEntity.setState(Lifecycle.State.valueOf((String)lifecycleState.name()));
        }
        if ((apiLifecycleState = api.getApiLifecycleState()) != null) {
            apiEntity.setLifecycleState(io.gravitee.rest.api.model.api.ApiLifecycleState.valueOf((String)apiLifecycleState.name()));
        }
        if (api.getVisibility() != null) {
            apiEntity.setVisibility(Visibility.valueOf((String)api.getVisibility().toString()));
        }
        EnvironmentEntity environmentEntity = this.environmentService.findById(api.getEnvironmentId());
        GraviteeContext.setCurrentOrganization((String)environmentEntity.getOrganizationId());
        apiEntity.setPrimaryOwner(this.apiService.getPrimaryOwner(api.getId()));
        return apiEntity;
    }
}

