/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.services.subscriptions;

import io.gravitee.apim.core.audit.model.AuditActor;
import io.gravitee.apim.core.subscription.use_case.CloseExpiredSubscriptionsUseCase;
import io.gravitee.common.service.AbstractService;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.Trigger;
import org.springframework.scheduling.support.CronTrigger;

public class ScheduledSubscriptionsService
extends AbstractService
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(ScheduledSubscriptionsService.class);
    @Autowired
    @Qualifier(value="subscriptionsTaskScheduler")
    private TaskScheduler scheduler;
    @Value(value="${services.subscriptions.cron:0 1 * * * *}")
    private String cronTrigger;
    @Value(value="${services.subscriptions.enabled:true}")
    private boolean enabled;
    private final AtomicLong counter = new AtomicLong(0L);
    @Autowired
    private CloseExpiredSubscriptionsUseCase closeExpiredSubscriptionsUsecase;

    protected String name() {
        return "Subscriptions Refresher Service";
    }

    protected void doStart() throws Exception {
        if (this.enabled) {
            super.doStart();
            this.logger.info("Subscriptions Refresher service has been initialized with cron [{}]", (Object)this.cronTrigger);
            this.scheduler.schedule((Runnable)this, (Trigger)new CronTrigger(this.cronTrigger));
        } else {
            this.logger.warn("Subscriptions Refresher service has been disabled");
        }
    }

    @Override
    public void run() {
        this.logger.debug("Refresh subscriptions #{} started at {}", (Object)this.counter.incrementAndGet(), (Object)Instant.now().toString());
        this.closeExpiredSubscriptionsUsecase.execute(new CloseExpiredSubscriptionsUseCase.Input(AuditActor.builder().userId("system").build()));
        this.logger.debug("Refresh subscriptions #{} ended at {}", (Object)this.counter.get(), (Object)Instant.now().toString());
    }
}

