/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.authentication.impl;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.rest.api.security.authentication.AuthenticationProvider;
import io.gravitee.rest.api.security.authentication.AuthenticationProviderManager;
import io.gravitee.rest.api.security.authentication.impl.DefaultAuthenticationProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.ConfigurableEnvironment;

public class AuthenticationProviderManagerImpl
implements AuthenticationProviderManager,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthenticationProviderManagerImpl.class);
    @Autowired
    private ConfigurableEnvironment environment;
    private List<AuthenticationProvider> identityProviders;

    public void afterPropertiesSet() throws Exception {
        log.info("Loading authentication providers");
        this.loadAuthenticationProviders();
    }

    @Override
    public List<AuthenticationProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    @Override
    public Optional<AuthenticationProvider> findIdentityProviderByType(String type) {
        return this.identityProviders.stream().filter(provider -> provider.type().equalsIgnoreCase(type)).findFirst();
    }

    private Map<String, Object> getConfiguration(AuthenticationProvider provider) {
        String prefix = "security.providers[" + provider.index() + "].";
        Map properties = EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)this.environment, (String)prefix);
        HashMap<String, Object> unprefixedProperties = new HashMap<String, Object>(properties.size());
        properties.entrySet().stream().forEach(propEntry -> unprefixedProperties.put(EnvironmentUtils.encodedKey((String)((String)propEntry.getKey())).substring(EnvironmentUtils.encodedKey((String)prefix).length()), propEntry.getValue()));
        return unprefixedProperties;
    }

    private void loadAuthenticationProviders() {
        log.debug("Looking for authentication providers...");
        this.identityProviders = new ArrayList<AuthenticationProvider>();
        boolean found = true;
        int idx = 0;
        while (found) {
            String type = this.environment.getProperty("security.providers[" + idx + "].type");
            boolean bl = found = type != null;
            if (found) {
                DefaultAuthenticationProvider provider = new DefaultAuthenticationProvider(type, idx);
                provider.setConfiguration(this.getConfiguration(provider));
                this.identityProviders.add(provider);
                log.debug("\tAuthentication provider [{}] has been defined", (Object)type);
            }
            ++idx;
        }
    }
}

