/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.csrf;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class CsrfRequestMatcher
implements RequestMatcher {
    private final Set<String> allowedMethods = new HashSet<String>(Arrays.asList("GET", "HEAD", "TRACE", "OPTIONS"));
    private final Set<Pattern> allowedPaths = new HashSet<Pattern>(Arrays.asList(Pattern.compile("^/organizations/[^/]+/user/login$")));

    public boolean matches(HttpServletRequest request) {
        return !this.allowedMethods.contains(request.getMethod()) && (request.getPathInfo() == null || !this.allowedPaths.stream().anyMatch(pattern -> pattern.matcher(request.getPathInfo()).matches())) && (request.getHeader("Referer") != null || request.getHeader("Origin") != null || request.getCookies() != null && Arrays.stream(request.getCookies()).anyMatch(cookie -> "Auth-Graviteeio-APIM".equals(cookie.getName())));
    }
}

