/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.utils;

import io.gravitee.rest.api.exception.InvalidImageException;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public final class ImageUtils {
    private static final Pattern DATA_IMAGE_PATTERN = Pattern.compile("data:(image/([a-zA-Z+]*));base64,(.*)", 2);
    private static final Set<String> ALLOWED_MIMETYPE = new HashSet<String>(Arrays.asList("gif", "jpeg", "webmp", "bmp", "png", "tiff"));
    private static final int IMAGE_MAX_SIZE = 500000;
    private static final int IMAGE_DEFAULT_WIDTH = 200;
    private static final int IMAGE_DEFAULT_HEIGHT = 200;

    private ImageUtils() {
    }

    public static void verify(String type, String mimeType, byte[] data) throws InvalidImageException {
        ImageUtils.verify(new Image(type, mimeType, data), 500000);
    }

    public static void verify(String picture) throws InvalidImageException {
        Image image = ImageUtils.decodePicture(picture);
        ImageUtils.verify(image, 500000);
    }

    public static void verify(String picture, int maxSize) throws InvalidImageException {
        Image image = ImageUtils.decodePicture(picture);
        ImageUtils.verify(image, maxSize);
    }

    private static void verify(Image image, int maxSize) throws InvalidImageException {
        if (image != null) {
            if (image.getSize() > maxSize) {
                throw new InvalidImageException("The image's size must be lower than " + maxSize);
            }
            ImageUtils.rescale(image, 200, 200);
        }
    }

    public static Image verifyAndRescale(String picture) throws InvalidImageException {
        return ImageUtils.verifyAndRescale(picture, 500000, 200, 200);
    }

    public static Image verifyAndRescale(String picture, int maxSize, int width, int height) throws InvalidImageException {
        Image image = ImageUtils.decodePicture(picture);
        if (image == null) {
            throw new InvalidImageException("The image cannot be decoded");
        }
        if (image.getSize() > maxSize) {
            throw new InvalidImageException("The image's size must be lower than " + maxSize);
        }
        return ImageUtils.rescale(image, width, height);
    }

    private static Image decodePicture(String picture) throws InvalidImageException {
        if (picture != null) {
            Matcher matcher = DATA_IMAGE_PATTERN.matcher(picture);
            if (matcher.matches()) {
                if (ALLOWED_MIMETYPE.contains(matcher.group(2).toLowerCase())) {
                    try {
                        return new Image(matcher.group(2), matcher.group(1), Base64.getDecoder().decode(matcher.group(3)));
                    }
                    catch (IllegalArgumentException iae) {
                        throw new InvalidImageException("Image is not a valid base64 format");
                    }
                }
                throw new InvalidImageException("Image mime-type " + matcher.group(1) + " is not allowed");
            }
            throw new InvalidImageException("Unknown image format");
        }
        return null;
    }

    private static Image rescale(Image image, int width, int height) throws InvalidImageException {
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(image.getData());
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageInputStream);
            if (imageReaders.hasNext()) {
                ImageReader reader = imageReaders.next();
                String discoveredType = reader.getFormatName();
                if (!ALLOWED_MIMETYPE.contains(discoveredType.toLowerCase())) {
                    throw new InvalidImageException(discoveredType + " format is not supported");
                }
                reader.setInput(imageInputStream);
                reader.getNumImages(true);
                BufferedImage bufferedImage = reader.read(0);
                java.awt.Image scaledImage = bufferedImage.getScaledInstance(width, height, 4);
                BufferedImage bufferedScaledImage = new BufferedImage(width, height, bufferedImage.getType());
                Graphics2D g2 = bufferedScaledImage.createGraphics();
                g2.drawImage(scaledImage, 0, 0, null);
                g2.dispose();
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedScaledImage, discoveredType, bos);
                return new Image(image.getType(), image.getMimeType(), bos.toByteArray());
            }
            throw new InvalidImageException("Image cannot be rescaled");
        }
        catch (IOException ioe) {
            throw new InvalidImageException("Image cannot be rescaled", (Throwable)ioe);
        }
    }

    public static class Image {
        private String type;
        private String mimeType;
        private byte[] data;

        public Image(String type, String mimeType, byte[] data) {
            this.type = type;
            this.mimeType = mimeType;
            this.data = data;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public int getSize() {
            return this.data == null ? 0 : this.data.length;
        }

        public String toBase64() {
            return "data:" + this.getMimeType() + ";base64," + Base64.getEncoder().encodeToString(this.data);
        }
    }
}

