/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.filter;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import io.gravitee.repository.management.model.Token;
import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.security.cookies.CookieGenerator;
import io.gravitee.rest.api.security.utils.AuthoritiesProvider;
import io.gravitee.rest.api.service.TokenService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

public class TokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    public static final String AUTH_COOKIE_NAME = "Auth-Graviteeio-APIM";
    public static final String TOKEN_AUTH_SCHEMA = "bearer";
    private final JWTVerifier jwtVerifier;
    private CookieGenerator cookieGenerator;
    private UserService userService;
    private TokenService tokenService;
    private AuthoritiesProvider authoritiesProvider;

    public TokenAuthenticationFilter(String jwtSecret, CookieGenerator cookieGenerator, UserService userService, TokenService tokenService, AuthoritiesProvider authoritiesProvider) {
        Algorithm algorithm = Algorithm.HMAC256((String)jwtSecret);
        this.jwtVerifier = JWT.require((Algorithm)algorithm).build();
        this.cookieGenerator = cookieGenerator;
        this.userService = userService;
        this.tokenService = tokenService;
        this.authoritiesProvider = authoritiesProvider;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Optional<Cookie> optionalStringToken;
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String stringToken = req.getHeader("Authorization");
        if (StringUtils.isEmpty((CharSequence)stringToken) && req.getCookies() != null && (optionalStringToken = Arrays.stream(req.getCookies()).filter(cookie -> AUTH_COOKIE_NAME.equals(cookie.getName())).findAny()).isPresent()) {
            stringToken = URLDecoder.decode(optionalStringToken.get().getValue(), Charset.defaultCharset().name());
        }
        if (StringUtils.isEmpty((CharSequence)stringToken)) {
            LOGGER.debug("Authorization header/cookie not found");
        } else {
            try {
                if (stringToken.toLowerCase().contains(TOKEN_AUTH_SCHEMA)) {
                    String tokenValue = stringToken.substring(TOKEN_AUTH_SCHEMA.length()).trim();
                    if (tokenValue.contains(".")) {
                        DecodedJWT jwt = this.jwtVerifier.verify(tokenValue);
                        Set<GrantedAuthority> authorities = this.authoritiesProvider.retrieveAuthorities(jwt.getClaim("sub").asString());
                        UserDetails userDetails = new UserDetails(this.getStringValue(jwt.getSubject()), "", authorities);
                        userDetails.setEmail(jwt.getClaim("email").asString());
                        userDetails.setFirstname(jwt.getClaim("firstname").asString());
                        userDetails.setLastname(jwt.getClaim("lastname").asString());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, null, authorities));
                    } else if (this.tokenService != null && this.userService != null) {
                        Token token = this.tokenService.findByToken(tokenValue);
                        UserEntity user = this.userService.findById(GraviteeContext.getExecutionContext(), token.getReferenceId());
                        Set<GrantedAuthority> authorities = this.authoritiesProvider.retrieveAuthorities(user.getId());
                        UserDetails userDetails = new UserDetails(user.getId(), "", authorities);
                        userDetails.setFirstname(user.getFirstname());
                        userDetails.setLastname(user.getLastname());
                        userDetails.setEmail(user.getEmail());
                        userDetails.setSource("token");
                        userDetails.setSourceId(token.getName());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, null, authorities));
                    }
                } else {
                    LOGGER.debug("Authorization schema not found");
                }
            }
            catch (Exception e) {
                String errorMessage = "Invalid token";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.error("Invalid token", (Throwable)e);
                } else if (e instanceof JWTVerificationException) {
                    LOGGER.warn("Invalid token");
                } else {
                    LOGGER.error("Invalid token");
                }
                res.addCookie(this.cookieGenerator.generate(AUTH_COOKIE_NAME, null));
                res.sendError(401);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private String getStringValue(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

