/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.security.listener;

import io.gravitee.rest.api.idp.api.authentication.UserDetails;
import io.gravitee.rest.api.model.MembershipMemberType;
import io.gravitee.rest.api.model.MembershipReferenceType;
import io.gravitee.rest.api.model.NewExternalUserEntity;
import io.gravitee.rest.api.model.RoleEntity;
import io.gravitee.rest.api.model.UpdateUserEntity;
import io.gravitee.rest.api.model.UserEntity;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import io.gravitee.rest.api.service.MembershipService;
import io.gravitee.rest.api.service.RoleService;
import io.gravitee.rest.api.service.UserService;
import io.gravitee.rest.api.service.common.GraviteeContext;
import io.gravitee.rest.api.service.exceptions.UserNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class AuthenticationSuccessListener
implements ApplicationListener<AuthenticationSuccessEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationSuccessListener.class);
    @Autowired
    private UserService userService;
    @Autowired
    private MembershipService membershipService;
    @Autowired
    private RoleService roleService;

    public void onApplicationEvent(AuthenticationSuccessEvent event) {
        UserDetails details;
        block5: {
            details = (UserDetails)event.getAuthentication().getPrincipal();
            try {
                UserEntity registeredUser = this.userService.findBySource(details.getSource(), details.getSourceId(), false);
                this.updateRegisteredUser(registeredUser, details);
                details.setUsername(registeredUser.getId());
                if ("memory".equals(details.getSource()) && registeredUser.getEmail() != null) {
                    details.setEmail(registeredUser.getEmail());
                    SecurityContextHolder.getContext().setAuthentication(event.getAuthentication());
                }
            }
            catch (UserNotFoundException unfe) {
                NewExternalUserEntity newUser = new NewExternalUserEntity();
                newUser.setSource(details.getSource());
                newUser.setSourceId(details.getSourceId());
                newUser.setFirstname(details.getFirstname());
                newUser.setLastname(details.getLastname());
                newUser.setEmail(details.getEmail());
                byte[] pictureData = details.getPicture();
                if (pictureData != null && pictureData.length > 0) {
                    String picture = this.computePicture(pictureData);
                    newUser.setPicture(picture);
                }
                boolean addDefaultRole = false;
                if (event.getAuthentication().getAuthorities() == null || event.getAuthentication().getAuthorities().isEmpty()) {
                    addDefaultRole = true;
                }
                UserEntity createdUser = this.userService.create(newUser, addDefaultRole);
                details.setUsername(createdUser.getId());
                if (addDefaultRole) break block5;
                this.addRole(RoleScope.ENVIRONMENT, createdUser.getId(), event.getAuthentication().getAuthorities());
                this.addRole(RoleScope.ORGANIZATION, createdUser.getId(), event.getAuthentication().getAuthorities());
            }
        }
        this.userService.connect(details.getUsername());
    }

    public String computePicture(byte[] pictureData) {
        String pictureContent = new String(pictureData);
        if (pictureContent.toUpperCase().startsWith("HTTP")) {
            return pictureContent;
        }
        try {
            String contentType = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(pictureData));
            if (contentType != null) {
                StringBuilder sb = new StringBuilder();
                sb.append("data:");
                sb.append(contentType);
                sb.append(";base64,");
                sb.append(StringUtils.newStringUtf8((byte[])Base64.encodeBase64((byte[])pictureData, (boolean)false)));
                return sb.toString();
            }
            LOGGER.warn("Unable to compute the user picture from URL.");
        }
        catch (IOException e) {
            LOGGER.warn("Problem while parsing picture", (Throwable)e);
        }
        return null;
    }

    private void updateRegisteredUser(UserEntity registeredUser, UserDetails details) {
        if (details.getFirstname() != null && !details.getFirstname().equals(registeredUser.getFirstname()) || details.getLastname() != null && !details.getLastname().equals(registeredUser.getLastname()) || details.getEmail() != null && !details.getEmail().equals(registeredUser.getEmail())) {
            UpdateUserEntity updateUserEntity = new UpdateUserEntity(registeredUser);
            updateUserEntity.setFirstname(details.getFirstname());
            updateUserEntity.setLastname(details.getLastname());
            updateUserEntity.setEmail(details.getEmail());
            this.userService.update(registeredUser.getId(), updateUserEntity);
        }
    }

    private String getRoleFromAuthorities(RoleScope roleScope, Collection<? extends GrantedAuthority> authorities) {
        String globalRole = null;
        String specificRole = null;
        for (GrantedAuthority grantedAuthority : authorities) {
            String authority = grantedAuthority.getAuthority();
            if (SystemRole.ADMIN.name().equals(authority)) {
                return authority;
            }
            if (authority.contains(":")) {
                String[] scopeAndName = authority.split(":");
                if (!roleScope.name().equals(scopeAndName[0])) continue;
                specificRole = scopeAndName[1];
                continue;
            }
            globalRole = authority;
        }
        return specificRole != null ? specificRole : globalRole;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRole(RoleScope roleScope, String userId, Collection<? extends GrantedAuthority> authorities) {
        String roleName;
        String role = this.getRoleFromAuthorities(roleScope, authorities);
        if (role != null && !SystemRole.ADMIN.name().equals(role)) {
            Optional optionalRole = this.roleService.findByScopeAndName(roleScope, role);
            if (optionalRole.isPresent()) {
                roleName = ((RoleEntity)optionalRole.get()).getName();
            } else {
                Optional first = this.roleService.findDefaultRoleByScopes(new RoleScope[]{roleScope}).stream().findFirst();
                if (!first.isPresent()) throw new IllegalArgumentException("No default role exist for scope " + roleScope.name());
                roleName = ((RoleEntity)first.get()).getName();
            }
        } else if (!SystemRole.ADMIN.name().equals(role)) {
            Optional first = this.roleService.findDefaultRoleByScopes(new RoleScope[]{roleScope}).stream().findFirst();
            if (!first.isPresent()) throw new IllegalArgumentException("No default role exist for scope " + roleScope.name());
            roleName = ((RoleEntity)first.get()).getName();
        } else {
            roleName = role;
        }
        MembershipService.MembershipReference membershipRef = roleScope == RoleScope.ENVIRONMENT ? new MembershipService.MembershipReference(MembershipReferenceType.ENVIRONMENT, GraviteeContext.getCurrentEnvironment()) : new MembershipService.MembershipReference(MembershipReferenceType.ORGANIZATION, GraviteeContext.getCurrentOrganization());
        this.membershipService.addRoleToMemberOnReference(membershipRef, new MembershipService.MembershipMember(userId, null, MembershipMemberType.USER), new MembershipService.MembershipRole(roleScope, roleName));
    }
}

