/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.subscription;

import io.gravitee.rest.api.model.SubscriptionStatus;
import java.util.Collection;
import java.util.Collections;
import lombok.Generated;

public class SubscriptionQuery {
    private Collection<String> apis;
    private Collection<String> excludedApis;
    private Collection<String> plans;
    private Collection<SubscriptionStatus> statuses;
    private Collection<String> applications;
    private Collection<String> planSecurityTypes;
    private String apiKey;
    private long from = -1L;
    private long to = -1L;
    private long endingAtAfter = -1L;
    private long endingAtBefore = -1L;
    private boolean includeWithoutEnd;

    public void setApi(String api) {
        if (api != null) {
            this.apis = Collections.singleton(api);
        }
    }

    public Collection<String> getExcludedApis() {
        return this.excludedApis;
    }

    public void setExcludedApis(Collection<String> excludedApis) {
        this.excludedApis = excludedApis;
    }

    public void setExcludedApis(String api) {
        if (api != null) {
            this.excludedApis = Collections.singleton(api);
        }
    }

    public Collection<String> getPlans() {
        return this.plans;
    }

    public void setPlans(Collection<String> plans) {
        this.plans = plans;
    }

    public void setPlan(String plan) {
        if (plan != null) {
            this.plans = Collections.singleton(plan);
        }
    }

    public void setApplication(String application) {
        if (application != null) {
            this.applications = Collections.singleton(application);
        }
    }

    public boolean matchesApi(String api) {
        return this.apis == null || this.apis.contains(api);
    }

    public boolean matchesPlan(String plan) {
        return this.plans == null || this.plans.contains(plan);
    }

    public boolean matchesApplication(String application) {
        return this.applications == null || this.applications.contains(application);
    }

    public boolean matchesStatus(SubscriptionStatus status) {
        return this.statuses == null || this.statuses.contains((Object)status);
    }

    @Generated
    public static SubscriptionQueryBuilder builder() {
        return new SubscriptionQueryBuilder();
    }

    @Generated
    public SubscriptionQuery(Collection<String> apis, Collection<String> excludedApis, Collection<String> plans, Collection<SubscriptionStatus> statuses, Collection<String> applications, Collection<String> planSecurityTypes, String apiKey, long from, long to, long endingAtAfter, long endingAtBefore, boolean includeWithoutEnd) {
        this.apis = apis;
        this.excludedApis = excludedApis;
        this.plans = plans;
        this.statuses = statuses;
        this.applications = applications;
        this.planSecurityTypes = planSecurityTypes;
        this.apiKey = apiKey;
        this.from = from;
        this.to = to;
        this.endingAtAfter = endingAtAfter;
        this.endingAtBefore = endingAtBefore;
        this.includeWithoutEnd = includeWithoutEnd;
    }

    @Generated
    public SubscriptionQuery() {
    }

    @Generated
    public Collection<String> getApis() {
        return this.apis;
    }

    @Generated
    public Collection<SubscriptionStatus> getStatuses() {
        return this.statuses;
    }

    @Generated
    public Collection<String> getApplications() {
        return this.applications;
    }

    @Generated
    public Collection<String> getPlanSecurityTypes() {
        return this.planSecurityTypes;
    }

    @Generated
    public String getApiKey() {
        return this.apiKey;
    }

    @Generated
    public long getFrom() {
        return this.from;
    }

    @Generated
    public long getTo() {
        return this.to;
    }

    @Generated
    public long getEndingAtAfter() {
        return this.endingAtAfter;
    }

    @Generated
    public long getEndingAtBefore() {
        return this.endingAtBefore;
    }

    @Generated
    public boolean isIncludeWithoutEnd() {
        return this.includeWithoutEnd;
    }

    @Generated
    public void setApis(Collection<String> apis) {
        this.apis = apis;
    }

    @Generated
    public void setStatuses(Collection<SubscriptionStatus> statuses) {
        this.statuses = statuses;
    }

    @Generated
    public void setApplications(Collection<String> applications) {
        this.applications = applications;
    }

    @Generated
    public void setPlanSecurityTypes(Collection<String> planSecurityTypes) {
        this.planSecurityTypes = planSecurityTypes;
    }

    @Generated
    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @Generated
    public void setFrom(long from) {
        this.from = from;
    }

    @Generated
    public void setTo(long to) {
        this.to = to;
    }

    @Generated
    public void setEndingAtAfter(long endingAtAfter) {
        this.endingAtAfter = endingAtAfter;
    }

    @Generated
    public void setEndingAtBefore(long endingAtBefore) {
        this.endingAtBefore = endingAtBefore;
    }

    @Generated
    public void setIncludeWithoutEnd(boolean includeWithoutEnd) {
        this.includeWithoutEnd = includeWithoutEnd;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionQuery)) {
            return false;
        }
        SubscriptionQuery other = (SubscriptionQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getTo() != other.getTo()) {
            return false;
        }
        if (this.getEndingAtAfter() != other.getEndingAtAfter()) {
            return false;
        }
        if (this.getEndingAtBefore() != other.getEndingAtBefore()) {
            return false;
        }
        if (this.isIncludeWithoutEnd() != other.isIncludeWithoutEnd()) {
            return false;
        }
        Collection<String> this$apis = this.getApis();
        Collection<String> other$apis = other.getApis();
        if (this$apis == null ? other$apis != null : !((Object)this$apis).equals(other$apis)) {
            return false;
        }
        Collection<String> this$excludedApis = this.getExcludedApis();
        Collection<String> other$excludedApis = other.getExcludedApis();
        if (this$excludedApis == null ? other$excludedApis != null : !((Object)this$excludedApis).equals(other$excludedApis)) {
            return false;
        }
        Collection<String> this$plans = this.getPlans();
        Collection<String> other$plans = other.getPlans();
        if (this$plans == null ? other$plans != null : !((Object)this$plans).equals(other$plans)) {
            return false;
        }
        Collection<SubscriptionStatus> this$statuses = this.getStatuses();
        Collection<SubscriptionStatus> other$statuses = other.getStatuses();
        if (this$statuses == null ? other$statuses != null : !((Object)this$statuses).equals(other$statuses)) {
            return false;
        }
        Collection<String> this$applications = this.getApplications();
        Collection<String> other$applications = other.getApplications();
        if (this$applications == null ? other$applications != null : !((Object)this$applications).equals(other$applications)) {
            return false;
        }
        Collection<String> this$planSecurityTypes = this.getPlanSecurityTypes();
        Collection<String> other$planSecurityTypes = other.getPlanSecurityTypes();
        if (this$planSecurityTypes == null ? other$planSecurityTypes != null : !((Object)this$planSecurityTypes).equals(other$planSecurityTypes)) {
            return false;
        }
        String this$apiKey = this.getApiKey();
        String other$apiKey = other.getApiKey();
        return !(this$apiKey == null ? other$apiKey != null : !this$apiKey.equals(other$apiKey));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionQuery;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $from = this.getFrom();
        result = result * 59 + (int)($from >>> 32 ^ $from);
        long $to = this.getTo();
        result = result * 59 + (int)($to >>> 32 ^ $to);
        long $endingAtAfter = this.getEndingAtAfter();
        result = result * 59 + (int)($endingAtAfter >>> 32 ^ $endingAtAfter);
        long $endingAtBefore = this.getEndingAtBefore();
        result = result * 59 + (int)($endingAtBefore >>> 32 ^ $endingAtBefore);
        result = result * 59 + (this.isIncludeWithoutEnd() ? 79 : 97);
        Collection<String> $apis = this.getApis();
        result = result * 59 + ($apis == null ? 43 : ((Object)$apis).hashCode());
        Collection<String> $excludedApis = this.getExcludedApis();
        result = result * 59 + ($excludedApis == null ? 43 : ((Object)$excludedApis).hashCode());
        Collection<String> $plans = this.getPlans();
        result = result * 59 + ($plans == null ? 43 : ((Object)$plans).hashCode());
        Collection<SubscriptionStatus> $statuses = this.getStatuses();
        result = result * 59 + ($statuses == null ? 43 : ((Object)$statuses).hashCode());
        Collection<String> $applications = this.getApplications();
        result = result * 59 + ($applications == null ? 43 : ((Object)$applications).hashCode());
        Collection<String> $planSecurityTypes = this.getPlanSecurityTypes();
        result = result * 59 + ($planSecurityTypes == null ? 43 : ((Object)$planSecurityTypes).hashCode());
        String $apiKey = this.getApiKey();
        result = result * 59 + ($apiKey == null ? 43 : $apiKey.hashCode());
        return result;
    }

    @Generated
    public static class SubscriptionQueryBuilder {
        @Generated
        private Collection<String> apis;
        @Generated
        private Collection<String> excludedApis;
        @Generated
        private Collection<String> plans;
        @Generated
        private Collection<SubscriptionStatus> statuses;
        @Generated
        private Collection<String> applications;
        @Generated
        private Collection<String> planSecurityTypes;
        @Generated
        private String apiKey;
        @Generated
        private long from;
        @Generated
        private long to;
        @Generated
        private long endingAtAfter;
        @Generated
        private long endingAtBefore;
        @Generated
        private boolean includeWithoutEnd;

        @Generated
        SubscriptionQueryBuilder() {
        }

        @Generated
        public SubscriptionQueryBuilder apis(Collection<String> apis) {
            this.apis = apis;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder excludedApis(Collection<String> excludedApis) {
            this.excludedApis = excludedApis;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder plans(Collection<String> plans) {
            this.plans = plans;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder statuses(Collection<SubscriptionStatus> statuses) {
            this.statuses = statuses;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder applications(Collection<String> applications) {
            this.applications = applications;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder planSecurityTypes(Collection<String> planSecurityTypes) {
            this.planSecurityTypes = planSecurityTypes;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder from(long from) {
            this.from = from;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder to(long to) {
            this.to = to;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder endingAtAfter(long endingAtAfter) {
            this.endingAtAfter = endingAtAfter;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder endingAtBefore(long endingAtBefore) {
            this.endingAtBefore = endingAtBefore;
            return this;
        }

        @Generated
        public SubscriptionQueryBuilder includeWithoutEnd(boolean includeWithoutEnd) {
            this.includeWithoutEnd = includeWithoutEnd;
            return this;
        }

        @Generated
        public SubscriptionQuery build() {
            return new SubscriptionQuery(this.apis, this.excludedApis, this.plans, this.statuses, this.applications, this.planSecurityTypes, this.apiKey, this.from, this.to, this.endingAtAfter, this.endingAtBefore, this.includeWithoutEnd);
        }

        @Generated
        public String toString() {
            return "SubscriptionQuery.SubscriptionQueryBuilder(apis=" + String.valueOf(this.apis) + ", excludedApis=" + String.valueOf(this.excludedApis) + ", plans=" + String.valueOf(this.plans) + ", statuses=" + String.valueOf(this.statuses) + ", applications=" + String.valueOf(this.applications) + ", planSecurityTypes=" + String.valueOf(this.planSecurityTypes) + ", apiKey=" + this.apiKey + ", from=" + this.from + ", to=" + this.to + ", endingAtAfter=" + this.endingAtAfter + ", endingAtBefore=" + this.endingAtBefore + ", includeWithoutEnd=" + this.includeWithoutEnd + ")";
        }
    }
}

