/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.plan;

import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import lombok.Generated;

@Schema(enumAsRef=true, name="PlanValidationTypeV4")
public enum PlanValidationType {
    AUTO("auto"),
    MANUAL("manual");

    private static final Map<String, PlanValidationType> maps;
    @JsonValue
    private final String label;

    public static PlanValidationType valueOfLabel(String label) {
        if (label != null) {
            PlanValidationType planValidationType = maps.get(label);
            if (planValidationType == null) {
                try {
                    planValidationType = PlanValidationType.valueOf(label);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return planValidationType;
        }
        return null;
    }

    @Generated
    private PlanValidationType(String label) {
        this.label = label;
    }

    @Generated
    public String getLabel() {
        return this.label;
    }

    static {
        maps = Map.of(PlanValidationType.AUTO.label, AUTO, PlanValidationType.MANUAL.label, MANUAL);
    }
}

