/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.v4.plan;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.v4.flow.Flow;
import io.gravitee.definition.model.v4.plan.PlanMode;
import io.gravitee.definition.model.v4.plan.PlanSecurity;
import io.gravitee.definition.model.v4.plan.PlanStatus;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.v4.plan.PlanType;
import io.gravitee.rest.api.model.v4.plan.PlanValidationType;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;

@Schema(name="NewPlanEntityV4")
public class NewPlanEntity {
    private String id;
    private String crossId;
    private String apiId;
    @NotNull
    private String name;
    @NotNull
    private String description;
    @NotNull
    private PlanValidationType validation = PlanValidationType.MANUAL;
    @DeploymentRequired
    private PlanSecurity security;
    @NotNull
    private PlanType type = PlanType.API;
    @NotNull
    private PlanMode mode = PlanMode.STANDARD;
    @NotNull
    private PlanStatus status = PlanStatus.STAGING;
    @JsonProperty(required=true)
    private List<Flow> flows = new ArrayList<Flow>();
    private List<String> characteristics;
    private List<String> excludedGroups;
    private boolean commentRequired;
    private String commentMessage;
    private Set<String> tags;
    private String selectionRule;
    private String generalConditions;
    private int order;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    @Generated
    public NewPlanEntity() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getApiId() {
        return this.apiId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public PlanValidationType getValidation() {
        return this.validation;
    }

    @Generated
    public PlanSecurity getSecurity() {
        return this.security;
    }

    @Generated
    public PlanType getType() {
        return this.type;
    }

    @Generated
    public PlanMode getMode() {
        return this.mode;
    }

    @Generated
    public PlanStatus getStatus() {
        return this.status;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public List<String> getCharacteristics() {
        return this.characteristics;
    }

    @Generated
    public List<String> getExcludedGroups() {
        return this.excludedGroups;
    }

    @Generated
    public boolean isCommentRequired() {
        return this.commentRequired;
    }

    @Generated
    public String getCommentMessage() {
        return this.commentMessage;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getSelectionRule() {
        return this.selectionRule;
    }

    @Generated
    public String getGeneralConditions() {
        return this.generalConditions;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    @Generated
    public void setValidation(PlanValidationType validation) {
        this.validation = validation;
    }

    @Generated
    public void setSecurity(PlanSecurity security) {
        this.security = security;
    }

    @Generated
    public void setType(PlanType type) {
        this.type = type;
    }

    @Generated
    public void setMode(PlanMode mode) {
        this.mode = mode;
    }

    @Generated
    public void setStatus(PlanStatus status) {
        this.status = status;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setCharacteristics(List<String> characteristics) {
        this.characteristics = characteristics;
    }

    @Generated
    public void setExcludedGroups(List<String> excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    @Generated
    public void setCommentRequired(boolean commentRequired) {
        this.commentRequired = commentRequired;
    }

    @Generated
    public void setCommentMessage(String commentMessage) {
        this.commentMessage = commentMessage;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    @Generated
    public void setGeneralConditions(String generalConditions) {
        this.generalConditions = generalConditions;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public String toString() {
        return "NewPlanEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", apiId=" + this.getApiId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", validation=" + String.valueOf((Object)this.getValidation()) + ", security=" + String.valueOf(this.getSecurity()) + ", type=" + String.valueOf((Object)this.getType()) + ", mode=" + String.valueOf(this.getMode()) + ", status=" + String.valueOf(this.getStatus()) + ", flows=" + String.valueOf(this.getFlows()) + ", characteristics=" + String.valueOf(this.getCharacteristics()) + ", excludedGroups=" + String.valueOf(this.getExcludedGroups()) + ", commentRequired=" + this.isCommentRequired() + ", commentMessage=" + this.getCommentMessage() + ", tags=" + String.valueOf(this.getTags()) + ", selectionRule=" + this.getSelectionRule() + ", generalConditions=" + this.getGeneralConditions() + ", order=" + this.getOrder() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewPlanEntity)) {
            return false;
        }
        NewPlanEntity other = (NewPlanEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCommentRequired() != other.isCommentRequired()) {
            return false;
        }
        if (this.getOrder() != other.getOrder()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$crossId = this.getCrossId();
        String other$crossId = other.getCrossId();
        if (this$crossId == null ? other$crossId != null : !this$crossId.equals(other$crossId)) {
            return false;
        }
        String this$apiId = this.getApiId();
        String other$apiId = other.getApiId();
        if (this$apiId == null ? other$apiId != null : !this$apiId.equals(other$apiId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        PlanValidationType this$validation = this.getValidation();
        PlanValidationType other$validation = other.getValidation();
        if (this$validation == null ? other$validation != null : !((Object)((Object)this$validation)).equals((Object)other$validation)) {
            return false;
        }
        PlanSecurity this$security = this.getSecurity();
        PlanSecurity other$security = other.getSecurity();
        if (this$security == null ? other$security != null : !this$security.equals(other$security)) {
            return false;
        }
        PlanType this$type = this.getType();
        PlanType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        PlanMode this$mode = this.getMode();
        PlanMode other$mode = other.getMode();
        if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
            return false;
        }
        PlanStatus this$status = this.getStatus();
        PlanStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<Flow> this$flows = this.getFlows();
        List<Flow> other$flows = other.getFlows();
        if (this$flows == null ? other$flows != null : !((Object)this$flows).equals(other$flows)) {
            return false;
        }
        List<String> this$characteristics = this.getCharacteristics();
        List<String> other$characteristics = other.getCharacteristics();
        if (this$characteristics == null ? other$characteristics != null : !((Object)this$characteristics).equals(other$characteristics)) {
            return false;
        }
        List<String> this$excludedGroups = this.getExcludedGroups();
        List<String> other$excludedGroups = other.getExcludedGroups();
        if (this$excludedGroups == null ? other$excludedGroups != null : !((Object)this$excludedGroups).equals(other$excludedGroups)) {
            return false;
        }
        String this$commentMessage = this.getCommentMessage();
        String other$commentMessage = other.getCommentMessage();
        if (this$commentMessage == null ? other$commentMessage != null : !this$commentMessage.equals(other$commentMessage)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        String this$selectionRule = this.getSelectionRule();
        String other$selectionRule = other.getSelectionRule();
        if (this$selectionRule == null ? other$selectionRule != null : !this$selectionRule.equals(other$selectionRule)) {
            return false;
        }
        String this$generalConditions = this.getGeneralConditions();
        String other$generalConditions = other.getGeneralConditions();
        return !(this$generalConditions == null ? other$generalConditions != null : !this$generalConditions.equals(other$generalConditions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewPlanEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCommentRequired() ? 79 : 97);
        result = result * 59 + this.getOrder();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $crossId = this.getCrossId();
        result = result * 59 + ($crossId == null ? 43 : $crossId.hashCode());
        String $apiId = this.getApiId();
        result = result * 59 + ($apiId == null ? 43 : $apiId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        PlanValidationType $validation = this.getValidation();
        result = result * 59 + ($validation == null ? 43 : ((Object)((Object)$validation)).hashCode());
        PlanSecurity $security = this.getSecurity();
        result = result * 59 + ($security == null ? 43 : $security.hashCode());
        PlanType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        PlanMode $mode = this.getMode();
        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
        PlanStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<Flow> $flows = this.getFlows();
        result = result * 59 + ($flows == null ? 43 : ((Object)$flows).hashCode());
        List<String> $characteristics = this.getCharacteristics();
        result = result * 59 + ($characteristics == null ? 43 : ((Object)$characteristics).hashCode());
        List<String> $excludedGroups = this.getExcludedGroups();
        result = result * 59 + ($excludedGroups == null ? 43 : ((Object)$excludedGroups).hashCode());
        String $commentMessage = this.getCommentMessage();
        result = result * 59 + ($commentMessage == null ? 43 : $commentMessage.hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        String $selectionRule = this.getSelectionRule();
        result = result * 59 + ($selectionRule == null ? 43 : $selectionRule.hashCode());
        String $generalConditions = this.getGeneralConditions();
        result = result * 59 + ($generalConditions == null ? 43 : $generalConditions.hashCode());
        return result;
    }
}

