/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.gravitee.rest.api.sanitizer.HtmlSanitizer;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Set;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UpdateApplicationEntity {
    @NotNull(message="Application's name must not be null")
    @NotEmpty(message="Application's name must not be empty")
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private @NotNull(message="Application's name must not be null") @NotEmpty(message="Application's name must not be empty") String name;
    @NotNull(message="Application's description must not be null")
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private @NotNull(message="Application's description must not be null") String description;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    private String picture;
    @JsonProperty(value="picture_url")
    private String pictureUrl;
    @NotNull(message="Application's settings must not be null")
    private @NotNull(message="Application's settings must not be null") ApplicationSettings settings;
    @Schema(description="Application groups. Used to add teams to your application.", example="['Test Group 1', 'Test Group 2']")
    private Set<String> groups;
    @Deprecated
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    @Deprecated
    private String clientId;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API Key mode used for this application.")
    private ApiKeyMode apiKeyMode;
    private String background;

    public void setName(String name) {
        this.name = HtmlSanitizer.sanitize(name);
    }

    public void setDescription(String description) {
        this.description = HtmlSanitizer.sanitize(description);
    }

    @Generated
    public static UpdateApplicationEntityBuilder builder() {
        return new UpdateApplicationEntityBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Generated
    public ApplicationSettings getSettings() {
        return this.settings;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Deprecated
    @Generated
    public String getType() {
        return this.type;
    }

    @Deprecated
    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateApplicationEntity)) {
            return false;
        }
        UpdateApplicationEntity other = (UpdateApplicationEntity)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpdateApplicationEntity;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public UpdateApplicationEntity() {
    }

    @Generated
    public UpdateApplicationEntity(String name, String description, String domain, String picture, String pictureUrl, ApplicationSettings settings, Set<String> groups, String type, String clientId, boolean disableMembershipNotifications, ApiKeyMode apiKeyMode, String background) {
        this.name = name;
        this.description = description;
        this.domain = domain;
        this.picture = picture;
        this.pictureUrl = pictureUrl;
        this.settings = settings;
        this.groups = groups;
        this.type = type;
        this.clientId = clientId;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.apiKeyMode = apiKeyMode;
        this.background = background;
    }

    @Generated
    public String toString() {
        return "UpdateApplicationEntity(name=" + this.getName() + ", description=" + this.getDescription() + ", groups=" + String.valueOf(this.getGroups()) + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ")";
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="picture_url")
    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Generated
    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Deprecated
    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Deprecated
    @Generated
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonProperty(value="disable_membership_notifications")
    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @JsonProperty(value="api_key_mode")
    @Generated
    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public static class UpdateApplicationEntityBuilder {
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String domain;
        @Generated
        private String picture;
        @Generated
        private String pictureUrl;
        @Generated
        private ApplicationSettings settings;
        @Generated
        private Set<String> groups;
        @Generated
        private String type;
        @Generated
        private String clientId;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private ApiKeyMode apiKeyMode;
        @Generated
        private String background;

        @Generated
        UpdateApplicationEntityBuilder() {
        }

        @Generated
        public UpdateApplicationEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @JsonProperty(value="picture_url")
        @Generated
        public UpdateApplicationEntityBuilder pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder settings(ApplicationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Deprecated
        @Generated
        public UpdateApplicationEntityBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Deprecated
        @Generated
        public UpdateApplicationEntityBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="disable_membership_notifications")
        @Generated
        public UpdateApplicationEntityBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @JsonProperty(value="api_key_mode")
        @Generated
        public UpdateApplicationEntityBuilder apiKeyMode(ApiKeyMode apiKeyMode) {
            this.apiKeyMode = apiKeyMode;
            return this;
        }

        @Generated
        public UpdateApplicationEntityBuilder background(String background) {
            this.background = background;
            return this;
        }

        @Generated
        public UpdateApplicationEntity build() {
            return new UpdateApplicationEntity(this.name, this.description, this.domain, this.picture, this.pictureUrl, this.settings, this.groups, this.type, this.clientId, this.disableMembershipNotifications, this.apiKeyMode, this.background);
        }

        @Generated
        public String toString() {
            return "UpdateApplicationEntity.UpdateApplicationEntityBuilder(name=" + this.name + ", description=" + this.description + ", domain=" + this.domain + ", picture=" + this.picture + ", pictureUrl=" + this.pictureUrl + ", settings=" + String.valueOf(this.settings) + ", groups=" + String.valueOf(this.groups) + ", type=" + this.type + ", clientId=" + this.clientId + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", apiKeyMode=" + String.valueOf((Object)this.apiKeyMode) + ", background=" + this.background + ")";
        }
    }
}

