/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class RoleEntity {
    @NotNull
    private String id;
    private String name;
    private String description;
    private RoleScope scope;
    @JsonProperty(value="default")
    private boolean defaultRole;
    private boolean system;
    private Map<String, char[]> permissions;

    public boolean isApiPrimaryOwner() {
        return this.scope == RoleScope.API && SystemRole.PRIMARY_OWNER.name().equals(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleEntity that = (RoleEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Generated
    public static RoleEntityBuilder builder() {
        return new RoleEntityBuilder();
    }

    @Generated
    public RoleEntity(String id, String name, String description, RoleScope scope, boolean defaultRole, boolean system, Map<String, char[]> permissions) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.scope = scope;
        this.defaultRole = defaultRole;
        this.system = system;
        this.permissions = permissions;
    }

    @Generated
    public RoleEntity() {
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public RoleScope getScope() {
        return this.scope;
    }

    @Generated
    public boolean isDefaultRole() {
        return this.defaultRole;
    }

    @Generated
    public boolean isSystem() {
        return this.system;
    }

    @Generated
    public Map<String, char[]> getPermissions() {
        return this.permissions;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setScope(RoleScope scope) {
        this.scope = scope;
    }

    @Generated
    public void setDefaultRole(boolean defaultRole) {
        this.defaultRole = defaultRole;
    }

    @Generated
    public void setSystem(boolean system) {
        this.system = system;
    }

    @Generated
    public void setPermissions(Map<String, char[]> permissions) {
        this.permissions = permissions;
    }

    @Generated
    public String toString() {
        return "RoleEntity(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", scope=" + this.getScope() + ", defaultRole=" + this.isDefaultRole() + ", system=" + this.isSystem() + ", permissions=" + this.getPermissions() + ")";
    }

    @Generated
    public static class RoleEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private RoleScope scope;
        @Generated
        private boolean defaultRole;
        @Generated
        private boolean system;
        @Generated
        private Map<String, char[]> permissions;

        @Generated
        RoleEntityBuilder() {
        }

        @Generated
        public RoleEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public RoleEntityBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public RoleEntityBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public RoleEntityBuilder scope(RoleScope scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="default")
        @Generated
        public RoleEntityBuilder defaultRole(boolean defaultRole) {
            this.defaultRole = defaultRole;
            return this;
        }

        @Generated
        public RoleEntityBuilder system(boolean system) {
            this.system = system;
            return this;
        }

        @Generated
        public RoleEntityBuilder permissions(Map<String, char[]> permissions) {
            this.permissions = permissions;
            return this;
        }

        @Generated
        public RoleEntity build() {
            return new RoleEntity(this.id, this.name, this.description, this.scope, this.defaultRole, this.system, this.permissions);
        }

        @Generated
        public String toString() {
            return "RoleEntity.RoleEntityBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", scope=" + this.scope + ", defaultRole=" + this.defaultRole + ", system=" + this.system + ", permissions=" + this.permissions + ")";
        }
    }
}

