/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.context.OriginContext;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

@JsonFilter(value="apiMembershipTypeFilter")
public class ApiEntity
implements GenericApiEntity {
    @Schema(description="API's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="df83b2a4-cc3e-3f80-9f0d-c138c106c076")
    private String crossId;
    @Schema(description="ID of the environment where the API is in.", example="DEFAULT", accessMode=Schema.AccessMode.READ_ONLY)
    private String environmentId;
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private String name;
    @Schema(description="API's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="API's execution mode. Define if the execution mode should use v3 or v4-emulation-engine.", example="v3")
    @DeploymentRequired
    @JsonProperty(value="execution_mode")
    private ExecutionMode executionMode;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @JsonProperty(value="context_path")
    @Schema(description="API's context path.", example="/my-awesome-api")
    private String contextPath;
    @NotNull
    @DeploymentRequired
    @JsonProperty(value="proxy", required=true)
    @Schema(description="API's definition.")
    private Proxy proxy;
    @DeploymentRequired
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @DeploymentRequired
    @JsonProperty(value="paths")
    @Schema(description="a map where you can associate a path to a configuration (the policies configuration)")
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @DeploymentRequired
    @JsonProperty(value="flows")
    @Schema(description="a list of flows (the policies configuration)")
    private List<Flow> flows = new ArrayList<Flow>();
    @DeploymentRequired
    @JsonProperty(value="plans")
    @Schema(description="a list of plans with flows (the policies configuration)")
    private Set<PlanEntity> plans = new HashSet<PlanEntity>();
    @DeploymentRequired
    @JsonProperty(value="gravitee")
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;
    @JsonProperty(value="definition_context")
    @Schema(description="the context where the api definition was created from")
    private DefinitionContext definitionContext;
    @JsonProperty(value="deployed_at")
    @Schema(description="The last date (as timestamp) when the API was deployed.", example="1581256457163")
    private Date deployedAt;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the API was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the API was updated.", example="1581256457163")
    private Date updatedAt;
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="The status of the API regarding the gateway.", example="STARTED")
    private Lifecycle.State state;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @DeploymentRequired
    @JsonProperty(value="properties")
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    private Properties properties;
    @DeploymentRequired
    @JsonProperty(value="services")
    @Schema(description="The configuration of API services like the dynamic properties, the endpoint discovery or the healthcheck.")
    private Services services;
    @DeploymentRequired
    @Schema(description="the list of sharding tags associated with this API.", example="public, private")
    private Set<String> tags;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @JsonProperty(value="picture_url")
    @Schema(description="the API logo url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/picture")
    private String pictureUrl;
    @DeploymentRequired
    @JsonProperty(value="resources")
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    private List<Resource> resources = new ArrayList<Resource>();
    @Schema(description="the list of category keys associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    @DeploymentRequired
    @JsonProperty(value="path_mappings")
    @Schema(description="A list of paths used to aggregate data in analytics", example="/products/:productId, /products/:productId/media")
    private Set<String> pathMappings = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @DeploymentRequired
    @JsonProperty(value="response_templates")
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-ky is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    @JsonProperty(value="lifecycle_state")
    private ApiLifecycleState lifecycleState;
    @JsonProperty(value="workflow_state")
    private WorkflowState workflowState;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    private List<ApiEntrypointEntity> entrypoints;
    @Schema(description="the API background encoded in base64")
    private String background;
    @JsonProperty(value="background_url")
    @Schema(description="the API background url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/background")
    private String backgroundUrl;
    @JsonIgnore
    private String referenceType;
    @JsonIgnore
    private String referenceId;

    @JsonIgnore
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @JsonGetter(value="properties")
    public List<Property> getPropertyList() {
        if (this.properties != null) {
            return this.properties.getProperties();
        }
        return Collections.emptyList();
    }

    @JsonSetter(value="properties")
    public void setPropertyList(List<Property> properties) {
        this.properties = new Properties();
        this.properties.setProperties(properties);
    }

    @Override
    @JsonIgnore
    public String getApiVersion() {
        return this.version;
    }

    @Override
    @JsonIgnore
    public DefinitionVersion getDefinitionVersion() {
        if (this.graviteeDefinitionVersion != null) {
            return DefinitionVersion.valueOfLabel((String)this.graviteeDefinitionVersion);
        }
        return null;
    }

    @Override
    public OriginContext getOriginContext() {
        if (this.definitionContext == null) {
            return new OriginContext.Management();
        }
        if (this.definitionContext.isOriginKubernetes()) {
            return new OriginContext.Kubernetes(OriginContext.Kubernetes.Mode.valueOf(this.definitionContext.getMode().toUpperCase()), this.definitionContext.getSyncFrom());
        }
        return new OriginContext.Management();
    }

    @Generated
    private static Lifecycle.State $default$state() {
        return Lifecycle.State.STOPPED;
    }

    @Generated
    protected ApiEntity(ApiEntityBuilder<?, ?> b) {
        this.id = b.id;
        this.crossId = b.crossId;
        this.environmentId = b.environmentId;
        this.name = b.name;
        this.version = b.version;
        this.description = b.description;
        this.executionMode = b.executionMode;
        this.groups = b.groups;
        this.contextPath = b.contextPath;
        this.proxy = b.proxy;
        this.flowMode = b.flowMode;
        this.paths = b.paths;
        this.flows = b.flows;
        this.plans = b.plans;
        this.graviteeDefinitionVersion = b.graviteeDefinitionVersion;
        this.definitionContext = b.definitionContext;
        this.deployedAt = b.deployedAt;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.visibility = b.visibility;
        this.state = b.state$set ? b.state$value : ApiEntity.$default$state();
        this.primaryOwner = b.primaryOwner;
        this.properties = b.properties;
        this.services = b.services;
        this.tags = b.tags;
        this.picture = b.picture;
        this.pictureUrl = b.pictureUrl;
        this.resources = b.resources;
        this.categories = b.categories;
        this.labels = b.labels;
        this.pathMappings = b.pathMappings;
        this.metadata = b.metadata;
        this.responseTemplates = b.responseTemplates;
        this.lifecycleState = b.lifecycleState;
        this.workflowState = b.workflowState;
        this.disableMembershipNotifications = b.disableMembershipNotifications;
        this.entrypoints = b.entrypoints;
        this.background = b.background;
        this.backgroundUrl = b.backgroundUrl;
        this.referenceType = b.referenceType;
        this.referenceId = b.referenceId;
    }

    @Generated
    public static ApiEntityBuilder<?, ?> builder() {
        return new ApiEntityBuilderImpl();
    }

    @Generated
    public ApiEntityBuilder<?, ?> toBuilder() {
        return new ApiEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Override
    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    @Generated
    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<PlanEntity> getPlans() {
        return this.plans;
    }

    @Generated
    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    @Generated
    public DefinitionContext getDefinitionContext() {
        return this.definitionContext;
    }

    @Override
    @Generated
    public Date getDeployedAt() {
        return this.deployedAt;
    }

    @Override
    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @Generated
    public Lifecycle.State getState() {
        return this.state;
    }

    @Override
    @Generated
    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public Services getServices() {
        return this.services;
    }

    @Override
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    @Override
    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    @Override
    @Generated
    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Override
    @Generated
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    @Override
    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public List<ApiEntrypointEntity> getEntrypoints() {
        return this.entrypoints;
    }

    @Override
    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Override
    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Generated
    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Generated
    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    @Generated
    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @Generated
    public void setPlans(Set<PlanEntity> plans) {
        this.plans = plans;
    }

    @Generated
    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    @Generated
    public void setDefinitionContext(DefinitionContext definitionContext) {
        this.definitionContext = definitionContext;
    }

    @Generated
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setState(Lifecycle.State state) {
        this.state = state;
    }

    @Generated
    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @Generated
    public void setServices(Services services) {
        this.services = services;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @Generated
    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
    }

    @Override
    @Generated
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @Generated
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @Generated
    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setEntrypoints(List<ApiEntrypointEntity> entrypoints) {
        this.entrypoints = entrypoints;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Override
    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public String toString() {
        return "ApiEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", environmentId=" + this.getEnvironmentId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", executionMode=" + this.getExecutionMode() + ", groups=" + this.getGroups() + ", contextPath=" + this.getContextPath() + ", proxy=" + this.getProxy() + ", flowMode=" + this.getFlowMode() + ", paths=" + this.getPaths() + ", flows=" + this.getFlows() + ", plans=" + this.getPlans() + ", graviteeDefinitionVersion=" + this.getGraviteeDefinitionVersion() + ", definitionContext=" + this.getDefinitionContext() + ", deployedAt=" + this.getDeployedAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", visibility=" + this.getVisibility() + ", state=" + this.getState() + ", primaryOwner=" + this.getPrimaryOwner() + ", properties=" + this.getProperties() + ", services=" + this.getServices() + ", tags=" + this.getTags() + ", picture=" + this.getPicture() + ", pictureUrl=" + this.getPictureUrl() + ", resources=" + this.getResources() + ", categories=" + this.getCategories() + ", labels=" + this.getLabels() + ", pathMappings=" + this.getPathMappings() + ", metadata=" + this.getMetadata() + ", responseTemplates=" + this.getResponseTemplates() + ", lifecycleState=" + this.getLifecycleState() + ", workflowState=" + this.getWorkflowState() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", entrypoints=" + this.getEntrypoints() + ", background=" + this.getBackground() + ", backgroundUrl=" + this.getBackgroundUrl() + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiEntity)) {
            return false;
        }
        ApiEntity other = (ApiEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    public ApiEntity(String id, String crossId, String environmentId, String name, String version, String description, ExecutionMode executionMode, Set<String> groups, String contextPath, Proxy proxy, FlowMode flowMode, Map<String, List<Rule>> paths, List<Flow> flows, Set<PlanEntity> plans, String graviteeDefinitionVersion, DefinitionContext definitionContext, Date deployedAt, Date createdAt, Date updatedAt, Visibility visibility, Lifecycle.State state, PrimaryOwnerEntity primaryOwner, Properties properties, Services services, Set<String> tags, String picture, String pictureUrl, List<Resource> resources, Set<String> categories, List<String> labels, Set<String> pathMappings, Map<String, Object> metadata, Map<String, Map<String, ResponseTemplate>> responseTemplates, ApiLifecycleState lifecycleState, WorkflowState workflowState, boolean disableMembershipNotifications, List<ApiEntrypointEntity> entrypoints, String background, String backgroundUrl, String referenceType, String referenceId) {
        this.id = id;
        this.crossId = crossId;
        this.environmentId = environmentId;
        this.name = name;
        this.version = version;
        this.description = description;
        this.executionMode = executionMode;
        this.groups = groups;
        this.contextPath = contextPath;
        this.proxy = proxy;
        this.flowMode = flowMode;
        this.paths = paths;
        this.flows = flows;
        this.plans = plans;
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
        this.definitionContext = definitionContext;
        this.deployedAt = deployedAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.visibility = visibility;
        this.state = state;
        this.primaryOwner = primaryOwner;
        this.properties = properties;
        this.services = services;
        this.tags = tags;
        this.picture = picture;
        this.pictureUrl = pictureUrl;
        this.resources = resources;
        this.categories = categories;
        this.labels = labels;
        this.pathMappings = pathMappings;
        this.metadata = metadata;
        this.responseTemplates = responseTemplates;
        this.lifecycleState = lifecycleState;
        this.workflowState = workflowState;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.entrypoints = entrypoints;
        this.background = background;
        this.backgroundUrl = backgroundUrl;
        this.referenceType = referenceType;
        this.referenceId = referenceId;
    }

    @Generated
    public ApiEntity() {
        this.state = ApiEntity.$default$state();
    }

    @Generated
    public static abstract class ApiEntityBuilder<C extends ApiEntity, B extends ApiEntityBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String crossId;
        @Generated
        private String environmentId;
        @Generated
        private String name;
        @Generated
        private String version;
        @Generated
        private String description;
        @Generated
        private ExecutionMode executionMode;
        @Generated
        private Set<String> groups;
        @Generated
        private String contextPath;
        @Generated
        private Proxy proxy;
        @Generated
        private FlowMode flowMode;
        @Generated
        private Map<String, List<Rule>> paths;
        @Generated
        private List<Flow> flows;
        @Generated
        private Set<PlanEntity> plans;
        @Generated
        private String graviteeDefinitionVersion;
        @Generated
        private DefinitionContext definitionContext;
        @Generated
        private Date deployedAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private Visibility visibility;
        @Generated
        private boolean state$set;
        @Generated
        private Lifecycle.State state$value;
        @Generated
        private PrimaryOwnerEntity primaryOwner;
        @Generated
        private Properties properties;
        @Generated
        private Services services;
        @Generated
        private Set<String> tags;
        @Generated
        private String picture;
        @Generated
        private String pictureUrl;
        @Generated
        private List<Resource> resources;
        @Generated
        private Set<String> categories;
        @Generated
        private List<String> labels;
        @Generated
        private Set<String> pathMappings;
        @Generated
        private Map<String, Object> metadata;
        @Generated
        private Map<String, Map<String, ResponseTemplate>> responseTemplates;
        @Generated
        private ApiLifecycleState lifecycleState;
        @Generated
        private WorkflowState workflowState;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private List<ApiEntrypointEntity> entrypoints;
        @Generated
        private String background;
        @Generated
        private String backgroundUrl;
        @Generated
        private String referenceType;
        @Generated
        private String referenceId;

        @Generated
        protected B $fillValuesFrom(C instance) {
            ApiEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ApiEntity instance, ApiEntityBuilder<?, ?> b) {
            b.id(instance.id);
            b.crossId(instance.crossId);
            b.environmentId(instance.environmentId);
            b.name(instance.name);
            b.version(instance.version);
            b.description(instance.description);
            b.executionMode(instance.executionMode);
            b.groups(instance.groups);
            b.contextPath(instance.contextPath);
            b.proxy(instance.proxy);
            b.flowMode(instance.flowMode);
            b.paths(instance.paths);
            b.flows(instance.flows);
            b.plans(instance.plans);
            b.graviteeDefinitionVersion(instance.graviteeDefinitionVersion);
            b.definitionContext(instance.definitionContext);
            b.deployedAt(instance.deployedAt);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.visibility(instance.visibility);
            b.state(instance.state);
            b.primaryOwner(instance.primaryOwner);
            b.properties(instance.properties);
            b.services(instance.services);
            b.tags(instance.tags);
            b.picture(instance.picture);
            b.pictureUrl(instance.pictureUrl);
            b.resources(instance.resources);
            b.categories(instance.categories);
            b.labels(instance.labels);
            b.pathMappings(instance.pathMappings);
            b.metadata(instance.metadata);
            b.responseTemplates(instance.responseTemplates);
            b.lifecycleState(instance.lifecycleState);
            b.workflowState(instance.workflowState);
            b.disableMembershipNotifications(instance.disableMembershipNotifications);
            b.entrypoints(instance.entrypoints);
            b.background(instance.background);
            b.backgroundUrl(instance.backgroundUrl);
            b.referenceType(instance.referenceType);
            b.referenceId(instance.referenceId);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B crossId(String crossId) {
            this.crossId = crossId;
            return this.self();
        }

        @Generated
        public B environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @JsonProperty(value="execution_mode")
        @Generated
        public B executionMode(ExecutionMode executionMode) {
            this.executionMode = executionMode;
            return this.self();
        }

        @Generated
        public B groups(Set<String> groups) {
            this.groups = groups;
            return this.self();
        }

        @JsonProperty(value="context_path")
        @Generated
        public B contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this.self();
        }

        @JsonProperty(value="proxy", required=true)
        @Generated
        public B proxy(Proxy proxy) {
            this.proxy = proxy;
            return this.self();
        }

        @JsonProperty(value="flow_mode")
        @Generated
        public B flowMode(FlowMode flowMode) {
            this.flowMode = flowMode;
            return this.self();
        }

        @JsonProperty(value="paths")
        @Generated
        public B paths(Map<String, List<Rule>> paths) {
            this.paths = paths;
            return this.self();
        }

        @JsonProperty(value="flows")
        @Generated
        public B flows(List<Flow> flows) {
            this.flows = flows;
            return this.self();
        }

        @JsonProperty(value="plans")
        @Generated
        public B plans(Set<PlanEntity> plans) {
            this.plans = plans;
            return this.self();
        }

        @JsonProperty(value="gravitee")
        @Generated
        public B graviteeDefinitionVersion(String graviteeDefinitionVersion) {
            this.graviteeDefinitionVersion = graviteeDefinitionVersion;
            return this.self();
        }

        @JsonProperty(value="definition_context")
        @Generated
        public B definitionContext(DefinitionContext definitionContext) {
            this.definitionContext = definitionContext;
            return this.self();
        }

        @JsonProperty(value="deployed_at")
        @Generated
        public B deployedAt(Date deployedAt) {
            this.deployedAt = deployedAt;
            return this.self();
        }

        @JsonProperty(value="created_at")
        @Generated
        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @JsonProperty(value="updated_at")
        @Generated
        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @Generated
        public B visibility(Visibility visibility) {
            this.visibility = visibility;
            return this.self();
        }

        @Generated
        public B state(Lifecycle.State state) {
            this.state$value = state;
            this.state$set = true;
            return this.self();
        }

        @JsonProperty(value="owner")
        @Generated
        public B primaryOwner(PrimaryOwnerEntity primaryOwner) {
            this.primaryOwner = primaryOwner;
            return this.self();
        }

        @JsonProperty(value="properties")
        @Generated
        public B properties(Properties properties) {
            this.properties = properties;
            return this.self();
        }

        @JsonProperty(value="services")
        @Generated
        public B services(Services services) {
            this.services = services;
            return this.self();
        }

        @Generated
        public B tags(Set<String> tags) {
            this.tags = tags;
            return this.self();
        }

        @Generated
        public B picture(String picture) {
            this.picture = picture;
            return this.self();
        }

        @JsonProperty(value="picture_url")
        @Generated
        public B pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this.self();
        }

        @JsonProperty(value="resources")
        @Generated
        public B resources(List<Resource> resources) {
            this.resources = resources;
            return this.self();
        }

        @Generated
        public B categories(Set<String> categories) {
            this.categories = categories;
            return this.self();
        }

        @Generated
        public B labels(List<String> labels) {
            this.labels = labels;
            return this.self();
        }

        @JsonProperty(value="path_mappings")
        @Generated
        public B pathMappings(Set<String> pathMappings) {
            this.pathMappings = pathMappings;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this.self();
        }

        @JsonProperty(value="response_templates")
        @Generated
        public B responseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this.self();
        }

        @JsonProperty(value="lifecycle_state")
        @Generated
        public B lifecycleState(ApiLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this.self();
        }

        @JsonProperty(value="workflow_state")
        @Generated
        public B workflowState(WorkflowState workflowState) {
            this.workflowState = workflowState;
            return this.self();
        }

        @JsonProperty(value="disable_membership_notifications")
        @Generated
        public B disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this.self();
        }

        @Generated
        public B entrypoints(List<ApiEntrypointEntity> entrypoints) {
            this.entrypoints = entrypoints;
            return this.self();
        }

        @Generated
        public B background(String background) {
            this.background = background;
            return this.self();
        }

        @JsonProperty(value="background_url")
        @Generated
        public B backgroundUrl(String backgroundUrl) {
            this.backgroundUrl = backgroundUrl;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B referenceType(String referenceType) {
            this.referenceType = referenceType;
            return this.self();
        }

        @JsonIgnore
        @Generated
        public B referenceId(String referenceId) {
            this.referenceId = referenceId;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "ApiEntity.ApiEntityBuilder(id=" + this.id + ", crossId=" + this.crossId + ", environmentId=" + this.environmentId + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", executionMode=" + this.executionMode + ", groups=" + this.groups + ", contextPath=" + this.contextPath + ", proxy=" + this.proxy + ", flowMode=" + this.flowMode + ", paths=" + this.paths + ", flows=" + this.flows + ", plans=" + this.plans + ", graviteeDefinitionVersion=" + this.graviteeDefinitionVersion + ", definitionContext=" + this.definitionContext + ", deployedAt=" + this.deployedAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", visibility=" + this.visibility + ", state$value=" + this.state$value + ", primaryOwner=" + this.primaryOwner + ", properties=" + this.properties + ", services=" + this.services + ", tags=" + this.tags + ", picture=" + this.picture + ", pictureUrl=" + this.pictureUrl + ", resources=" + this.resources + ", categories=" + this.categories + ", labels=" + this.labels + ", pathMappings=" + this.pathMappings + ", metadata=" + this.metadata + ", responseTemplates=" + this.responseTemplates + ", lifecycleState=" + this.lifecycleState + ", workflowState=" + this.workflowState + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", entrypoints=" + this.entrypoints + ", background=" + this.background + ", backgroundUrl=" + this.backgroundUrl + ", referenceType=" + this.referenceType + ", referenceId=" + this.referenceId + ")";
        }
    }

    @Generated
    private static final class ApiEntityBuilderImpl
    extends ApiEntityBuilder<ApiEntity, ApiEntityBuilderImpl> {
        @Generated
        private ApiEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected ApiEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ApiEntity build() {
            return new ApiEntity(this);
        }
    }
}

