/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.context;

import lombok.Generated;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface OriginContext {
    public Origin origin();

    default public String name() {
        return this.origin().name().toLowerCase();
    }

    public static enum Origin {
        MANAGEMENT,
        KUBERNETES,
        INTEGRATION;

    }

    public static class Integration
    implements OriginContext {
        private final String integrationId;

        public Integration(String integrationId) {
            this.integrationId = integrationId;
        }

        @Override
        public Origin origin() {
            return Origin.INTEGRATION;
        }

        public String integrationId() {
            return this.integrationId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Integration)) {
                return false;
            }
            Integration other = (Integration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$integrationId = this.integrationId;
            String other$integrationId = other.integrationId;
            return !(this$integrationId == null ? other$integrationId != null : !this$integrationId.equals(other$integrationId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Integration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $integrationId = this.integrationId;
            result = result * 59 + ($integrationId == null ? 43 : $integrationId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OriginContext.Integration(integrationId=" + this.integrationId + ")";
        }
    }

    public record Management(Origin origin) implements OriginContext
    {
        public Management() {
            this(Origin.MANAGEMENT);
        }
    }

    public record Kubernetes(Origin origin, Mode mode, String syncFrom) implements OriginContext
    {
        public Kubernetes(Mode mode) {
            this(mode, Origin.KUBERNETES.name());
        }

        public Kubernetes(Mode mode, String syncFrom) {
            this(Origin.KUBERNETES, mode, syncFrom);
        }

        public static enum Mode {
            FULLY_MANAGED;

        }
    }
}

