/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Origin;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Set;
import lombok.Generated;

public class BaseApplicationEntity {
    @Schema(description="Application's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private String name;
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private String description;
    @Schema(description="Application's environment Id.", example="DEFAULT")
    private String environmentId;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    @Schema(description="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Schema(description="if the app is ACTIVE or ARCHIVED.", example="ACTIVE")
    private String status;
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    private String picture;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the application was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the application was updated.", example="1581256457163")
    private Date updatedAt;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API Key mode used for this application.")
    private ApiKeyMode apiKeyMode;
    private String background;
    @Schema(description="The origin used for creating this application.")
    private Origin origin;

    public boolean hasApiKeySharedMode() {
        return this.getApiKeyMode() == ApiKeyMode.SHARED;
    }

    @Generated
    protected BaseApplicationEntity(BaseApplicationEntityBuilder<?, ?> b) {
        this.id = b.id;
        this.name = b.name;
        this.description = b.description;
        this.environmentId = b.environmentId;
        this.domain = b.domain;
        this.groups = b.groups;
        this.status = b.status;
        this.type = b.type;
        this.picture = b.picture;
        this.createdAt = b.createdAt;
        this.updatedAt = b.updatedAt;
        this.disableMembershipNotifications = b.disableMembershipNotifications;
        this.apiKeyMode = b.apiKeyMode;
        this.background = b.background;
        this.origin = b.origin;
    }

    @Generated
    public static BaseApplicationEntityBuilder<?, ?> builder() {
        return new BaseApplicationEntityBuilderImpl();
    }

    @Generated
    public BaseApplicationEntityBuilder<?, ?> toBuilder() {
        return new BaseApplicationEntityBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Generated
    public String getDomain() {
        return this.domain;
    }

    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public Origin getOrigin() {
        return this.origin;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    @Generated
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonProperty(value="disable_membership_notifications")
    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @JsonProperty(value="api_key_mode")
    @Generated
    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @Generated
    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    @Generated
    public String toString() {
        return "BaseApplicationEntity(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", environmentId=" + this.getEnvironmentId() + ", domain=" + this.getDomain() + ", groups=" + this.getGroups() + ", status=" + this.getStatus() + ", type=" + this.getType() + ", picture=" + this.getPicture() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", apiKeyMode=" + this.getApiKeyMode() + ", background=" + this.getBackground() + ", origin=" + this.getOrigin() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseApplicationEntity)) {
            return false;
        }
        BaseApplicationEntity other = (BaseApplicationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseApplicationEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    @Generated
    public BaseApplicationEntity(String id, String name, String description, String environmentId, String domain, Set<String> groups, String status, String type, String picture, Date createdAt, Date updatedAt, boolean disableMembershipNotifications, ApiKeyMode apiKeyMode, String background, Origin origin) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.environmentId = environmentId;
        this.domain = domain;
        this.groups = groups;
        this.status = status;
        this.type = type;
        this.picture = picture;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.apiKeyMode = apiKeyMode;
        this.background = background;
        this.origin = origin;
    }

    @Generated
    public BaseApplicationEntity() {
    }

    @Generated
    public static abstract class BaseApplicationEntityBuilder<C extends BaseApplicationEntity, B extends BaseApplicationEntityBuilder<C, B>> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String environmentId;
        @Generated
        private String domain;
        @Generated
        private Set<String> groups;
        @Generated
        private String status;
        @Generated
        private String type;
        @Generated
        private String picture;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private ApiKeyMode apiKeyMode;
        @Generated
        private String background;
        @Generated
        private Origin origin;

        @Generated
        protected B $fillValuesFrom(C instance) {
            BaseApplicationEntityBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BaseApplicationEntity instance, BaseApplicationEntityBuilder<?, ?> b) {
            b.id(instance.id);
            b.name(instance.name);
            b.description(instance.description);
            b.environmentId(instance.environmentId);
            b.domain(instance.domain);
            b.groups(instance.groups);
            b.status(instance.status);
            b.type(instance.type);
            b.picture(instance.picture);
            b.createdAt(instance.createdAt);
            b.updatedAt(instance.updatedAt);
            b.disableMembershipNotifications(instance.disableMembershipNotifications);
            b.apiKeyMode(instance.apiKeyMode);
            b.background(instance.background);
            b.origin(instance.origin);
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return this.self();
        }

        @Generated
        public B environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this.self();
        }

        @Generated
        public B domain(String domain) {
            this.domain = domain;
            return this.self();
        }

        @Generated
        public B groups(Set<String> groups) {
            this.groups = groups;
            return this.self();
        }

        @Generated
        public B status(String status) {
            this.status = status;
            return this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return this.self();
        }

        @Generated
        public B picture(String picture) {
            this.picture = picture;
            return this.self();
        }

        @JsonProperty(value="created_at")
        @Generated
        public B createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this.self();
        }

        @JsonProperty(value="updated_at")
        @Generated
        public B updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this.self();
        }

        @JsonProperty(value="disable_membership_notifications")
        @Generated
        public B disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this.self();
        }

        @JsonProperty(value="api_key_mode")
        @Generated
        public B apiKeyMode(ApiKeyMode apiKeyMode) {
            this.apiKeyMode = apiKeyMode;
            return this.self();
        }

        @Generated
        public B background(String background) {
            this.background = background;
            return this.self();
        }

        @Generated
        public B origin(Origin origin) {
            this.origin = origin;
            return this.self();
        }

        @Generated
        protected abstract B self();

        @Generated
        public abstract C build();

        @Generated
        public String toString() {
            return "BaseApplicationEntity.BaseApplicationEntityBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", environmentId=" + this.environmentId + ", domain=" + this.domain + ", groups=" + this.groups + ", status=" + this.status + ", type=" + this.type + ", picture=" + this.picture + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", apiKeyMode=" + this.apiKeyMode + ", background=" + this.background + ", origin=" + this.origin + ")";
        }
    }

    @Generated
    private static final class BaseApplicationEntityBuilderImpl
    extends BaseApplicationEntityBuilder<BaseApplicationEntity, BaseApplicationEntityBuilderImpl> {
        @Generated
        private BaseApplicationEntityBuilderImpl() {
        }

        @Override
        @Generated
        protected BaseApplicationEntityBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BaseApplicationEntity build() {
            return new BaseApplicationEntity(this);
        }
    }
}

