/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.configuration.identity.github;

import io.gravitee.rest.api.model.configuration.identity.IdentityProviderType;
import io.gravitee.rest.api.model.configuration.identity.SocialIdentityProviderEntity;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GitHubIdentityProviderEntity
extends SocialIdentityProviderEntity {
    private static final String AUTHORIZATION_URL = "https://github.com/login/oauth/authorize";
    private static final String ACCESS_TOKEN_URL = "https://github.com/login/oauth/access_token";
    private static final String USER_INFO_URL = "https://api.github.com/user";
    private static final String AUTHORIZATION_HEADER = "token %s";

    @Override
    public IdentityProviderType getType() {
        return IdentityProviderType.GITHUB;
    }

    @Override
    public String getAuthorizationEndpoint() {
        return AUTHORIZATION_URL;
    }

    @Override
    public String getTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    @Override
    public String getUserInfoEndpoint() {
        return USER_INFO_URL;
    }

    @Override
    public String getAuthorizationHeader() {
        return AUTHORIZATION_HEADER;
    }

    @Override
    public List<String> getRequiredUrlParams() {
        return null;
    }

    @Override
    public List<String> getOptionalUrlParams() {
        return Collections.singletonList("scope");
    }

    @Override
    public List<String> getScopes() {
        return Collections.singletonList("user:email");
    }

    @Override
    public String getDisplay() {
        return null;
    }

    @Override
    public String getColor() {
        return null;
    }

    @Override
    public Map<String, String> getUserProfileMapping() {
        HashMap<String, String> userProfileMapping = new HashMap<String, String>();
        userProfileMapping.put("id", this.isEmailRequired() ? "email" : "id");
        userProfileMapping.put("sub", "id");
        userProfileMapping.put("email", "email");
        userProfileMapping.put("firstname", "{#jsonPath(#profile, '$.name').split(' ')[0]}");
        userProfileMapping.put("lastname", "{#jsonPath(#profile, '$.name').split(' ').length == 1 ? #jsonPath(#profile, '$.name').split(' ')[0] : #jsonPath(#profile, '$.name').split(' ')[1]}");
        userProfileMapping.put("picture", "avatar_url");
        return userProfileMapping;
    }
}

