/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Properties;
import io.gravitee.rest.api.model.PropertyEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class PropertiesEntity {
    @JsonProperty(value="properties")
    private List<PropertyEntity> properties = new ArrayList<PropertyEntity>();

    public PropertiesEntity() {
    }

    public PropertiesEntity(List<PropertyEntity> properties) {
        this.properties = properties;
    }

    public PropertiesEntity(Properties properties) {
        if (properties != null && properties.getProperties() != null) {
            this.properties = properties.getProperties().stream().map(PropertyEntity::new).collect(Collectors.toList());
        }
    }

    public List<PropertyEntity> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyEntity> properties) {
        this.properties = properties;
    }

    public Properties toDefinition() {
        Properties definitionProperties = new Properties();
        definitionProperties.setProperties(this.properties.stream().map(property -> property).collect(Collectors.toList()));
        return definitionProperties;
    }
}

