/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.application;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.definition.model.Origin;
import io.gravitee.rest.api.model.ApiKeyMode;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public class ApplicationListItem {
    @Schema(description="Application's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="Application's name. Duplicate names can exists.", example="My App")
    private String name;
    @Schema(description="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private String description;
    @Schema(description="Domain used by the application, if relevant", example="https://my-app.com")
    private String domain;
    @Schema(description="Application groups. Used to add teams to your application.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Schema(description="if the app is ACTIVE or ARCHIVED.", example="ACTIVE")
    private String status;
    @Schema(description="a string to describe the type of your app.", example="iOS")
    private String type;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the application was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the application was updated.", example="1581256457163")
    private Date updatedAt;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @JsonProperty(value="settings")
    private ApplicationSettings settings;
    private String picture;
    @JsonProperty(value="picture_url")
    private String pictureUrl;
    private String background;
    @JsonProperty(value="background_url")
    private String backgroundUrl;
    @JsonProperty(value="api_key_mode")
    @Schema(description="The API Key mode used for this application.")
    private ApiKeyMode apiKeyMode;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    @JsonProperty(value="origin")
    private Origin origin;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public ApiKeyMode getApiKeyMode() {
        return this.apiKeyMode;
    }

    public void setApiKeyMode(ApiKeyMode apiKeyMode) {
        this.apiKeyMode = apiKeyMode;
    }

    public boolean hasApiKeySharedMode() {
        return this.apiKeyMode == ApiKeyMode.SHARED;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationListItem that = (ApplicationListItem)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Application{");
        sb.append("id='").append(this.id).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", createdAt=").append(this.createdAt);
        sb.append('}');
        return sb.toString();
    }

    @Generated
    public static ApplicationListItemBuilder builder() {
        return new ApplicationListItemBuilder();
    }

    @Generated
    public ApplicationListItemBuilder toBuilder() {
        return new ApplicationListItemBuilder().id(this.id).name(this.name).description(this.description).domain(this.domain).groups(this.groups).status(this.status).type(this.type).createdAt(this.createdAt).updatedAt(this.updatedAt).primaryOwner(this.primaryOwner).settings(this.settings).picture(this.picture).pictureUrl(this.pictureUrl).background(this.background).backgroundUrl(this.backgroundUrl).apiKeyMode(this.apiKeyMode).disableMembershipNotifications(this.disableMembershipNotifications).origin(this.origin);
    }

    @Generated
    public ApplicationListItem(String id, String name, String description, String domain, Set<String> groups, String status, String type, Date createdAt, Date updatedAt, PrimaryOwnerEntity primaryOwner, ApplicationSettings settings, String picture, String pictureUrl, String background, String backgroundUrl, ApiKeyMode apiKeyMode, boolean disableMembershipNotifications, Origin origin) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.domain = domain;
        this.groups = groups;
        this.status = status;
        this.type = type;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.primaryOwner = primaryOwner;
        this.settings = settings;
        this.picture = picture;
        this.pictureUrl = pictureUrl;
        this.background = background;
        this.backgroundUrl = backgroundUrl;
        this.apiKeyMode = apiKeyMode;
        this.disableMembershipNotifications = disableMembershipNotifications;
        this.origin = origin;
    }

    @Generated
    public ApplicationListItem() {
    }

    @Generated
    public static class ApplicationListItemBuilder {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private String domain;
        @Generated
        private Set<String> groups;
        @Generated
        private String status;
        @Generated
        private String type;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private PrimaryOwnerEntity primaryOwner;
        @Generated
        private ApplicationSettings settings;
        @Generated
        private String picture;
        @Generated
        private String pictureUrl;
        @Generated
        private String background;
        @Generated
        private String backgroundUrl;
        @Generated
        private ApiKeyMode apiKeyMode;
        @Generated
        private boolean disableMembershipNotifications;
        @Generated
        private Origin origin;

        @Generated
        ApplicationListItemBuilder() {
        }

        @Generated
        public ApplicationListItemBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder groups(Set<String> groups) {
            this.groups = groups;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder status(String status) {
            this.status = status;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public ApplicationListItemBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        @Generated
        public ApplicationListItemBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @JsonProperty(value="owner")
        @Generated
        public ApplicationListItemBuilder primaryOwner(PrimaryOwnerEntity primaryOwner) {
            this.primaryOwner = primaryOwner;
            return this;
        }

        @JsonProperty(value="settings")
        @Generated
        public ApplicationListItemBuilder settings(ApplicationSettings settings) {
            this.settings = settings;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder picture(String picture) {
            this.picture = picture;
            return this;
        }

        @JsonProperty(value="picture_url")
        @Generated
        public ApplicationListItemBuilder pictureUrl(String pictureUrl) {
            this.pictureUrl = pictureUrl;
            return this;
        }

        @Generated
        public ApplicationListItemBuilder background(String background) {
            this.background = background;
            return this;
        }

        @JsonProperty(value="background_url")
        @Generated
        public ApplicationListItemBuilder backgroundUrl(String backgroundUrl) {
            this.backgroundUrl = backgroundUrl;
            return this;
        }

        @JsonProperty(value="api_key_mode")
        @Generated
        public ApplicationListItemBuilder apiKeyMode(ApiKeyMode apiKeyMode) {
            this.apiKeyMode = apiKeyMode;
            return this;
        }

        @JsonProperty(value="disable_membership_notifications")
        @Generated
        public ApplicationListItemBuilder disableMembershipNotifications(boolean disableMembershipNotifications) {
            this.disableMembershipNotifications = disableMembershipNotifications;
            return this;
        }

        @JsonProperty(value="origin")
        @Generated
        public ApplicationListItemBuilder origin(Origin origin) {
            this.origin = origin;
            return this;
        }

        @Generated
        public ApplicationListItem build() {
            return new ApplicationListItem(this.id, this.name, this.description, this.domain, this.groups, this.status, this.type, this.createdAt, this.updatedAt, this.primaryOwner, this.settings, this.picture, this.pictureUrl, this.background, this.backgroundUrl, this.apiKeyMode, this.disableMembershipNotifications, this.origin);
        }

        @Generated
        public String toString() {
            return "ApplicationListItem.ApplicationListItemBuilder(id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", domain=" + this.domain + ", groups=" + this.groups + ", status=" + this.status + ", type=" + this.type + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", primaryOwner=" + this.primaryOwner + ", settings=" + this.settings + ", picture=" + this.picture + ", pictureUrl=" + this.pictureUrl + ", background=" + this.background + ", backgroundUrl=" + this.backgroundUrl + ", apiKeyMode=" + this.apiKeyMode + ", disableMembershipNotifications=" + this.disableMembershipNotifications + ", origin=" + this.origin + ")";
        }
    }
}

