/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.sanitizer;

import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

public final class HtmlSanitizer {
    private static final PolicyFactory HTML_SANITIZER = new HtmlPolicyBuilder().toFactory();

    private static String unSanitizeAllowedChars(String content) {
        if (content == null) {
            return null;
        }
        return content.replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&amp;", "&").replaceAll("&#34;", "\"").replaceAll("&#39;", "'").replaceAll("&#43;", "+").replaceAll("&#61;", "=").replaceAll("&#96;", "`");
    }

    public static String sanitize(String content) {
        if (content == null) {
            return null;
        }
        return HtmlSanitizer.unSanitizeAllowedChars(HTML_SANITIZER.sanitize(HtmlSanitizer.unSanitizeAllowedChars(content)));
    }
}

