/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.permissions.RoleScope;
import io.gravitee.rest.api.model.permissions.SystemRole;
import jakarta.validation.constraints.NotNull;
import java.util.Map;
import java.util.Objects;

public class RoleEntity {
    @NotNull
    private String id;
    private String name;
    private String description;
    private RoleScope scope;
    @JsonProperty(value="default")
    private boolean defaultRole;
    private boolean system;
    private Map<String, char[]> permissions;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RoleScope getScope() {
        return this.scope;
    }

    public void setScope(RoleScope scope) {
        this.scope = scope;
    }

    public Map<String, char[]> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Map<String, char[]> permissions) {
        this.permissions = permissions;
    }

    public boolean isDefaultRole() {
        return this.defaultRole;
    }

    public void setDefaultRole(boolean defaultRole) {
        this.defaultRole = defaultRole;
    }

    public boolean isSystem() {
        return this.system;
    }

    public void setSystem(boolean system) {
        this.system = system;
    }

    public boolean isApiPrimaryOwner() {
        return this.scope == RoleScope.API && SystemRole.PRIMARY_OWNER.name().equals(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleEntity that = (RoleEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

