/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.ApplicationEntity;
import io.gravitee.rest.api.model.SubscriptionEntity;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;

public class ApiKeyEntity {
    private String id;
    private String key;
    private Set<SubscriptionEntity> subscriptions;
    private ApplicationEntity application;
    @JsonProperty(value="expire_at")
    private Date expireAt;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    private boolean revoked;
    @JsonProperty(value="revoked_at")
    private Date revokedAt;
    private boolean paused;
    private boolean expired;
    private Integer daysToExpirationOnLastNotification;

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Date getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(Date expireAt) {
        this.expireAt = expireAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public boolean isRevoked() {
        return this.revoked;
    }

    public void setRevoked(boolean revoked) {
        this.revoked = revoked;
    }

    public Date getRevokedAt() {
        return this.revokedAt;
    }

    public void setRevokedAt(Date revokedAt) {
        this.revokedAt = revokedAt;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public Integer getDaysToExpirationOnLastNotification() {
        return this.daysToExpirationOnLastNotification;
    }

    public void setDaysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<SubscriptionEntity> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Set<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public ApplicationEntity getApplication() {
        return this.application;
    }

    public void setApplication(ApplicationEntity application) {
        this.application = application;
    }

    @JsonIgnore
    public List<String> getSubscriptionIds() {
        return this.subscriptions.stream().map(SubscriptionEntity::getId).collect(Collectors.toList());
    }

    public boolean hasSubscription(String subscriptionId) {
        return this.getSubscriptionIds().stream().anyMatch(subscriptionId::equals);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiKeyEntity that = (ApiKeyEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Generated
    private static Set<SubscriptionEntity> $default$subscriptions() {
        return new HashSet<SubscriptionEntity>();
    }

    @Generated
    public static ApiKeyEntityBuilder builder() {
        return new ApiKeyEntityBuilder();
    }

    @Generated
    public ApiKeyEntityBuilder toBuilder() {
        return new ApiKeyEntityBuilder().id(this.id).key(this.key).subscriptions(this.subscriptions).application(this.application).expireAt(this.expireAt).createdAt(this.createdAt).updatedAt(this.updatedAt).revoked(this.revoked).revokedAt(this.revokedAt).paused(this.paused).expired(this.expired).daysToExpirationOnLastNotification(this.daysToExpirationOnLastNotification);
    }

    @Generated
    public ApiKeyEntity(String id, String key, Set<SubscriptionEntity> subscriptions, ApplicationEntity application, Date expireAt, Date createdAt, Date updatedAt, boolean revoked, Date revokedAt, boolean paused, boolean expired, Integer daysToExpirationOnLastNotification) {
        this.id = id;
        this.key = key;
        this.subscriptions = subscriptions;
        this.application = application;
        this.expireAt = expireAt;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.revoked = revoked;
        this.revokedAt = revokedAt;
        this.paused = paused;
        this.expired = expired;
        this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
    }

    @Generated
    public ApiKeyEntity() {
        this.subscriptions = ApiKeyEntity.$default$subscriptions();
    }

    @Generated
    public static class ApiKeyEntityBuilder {
        @Generated
        private String id;
        @Generated
        private String key;
        @Generated
        private boolean subscriptions$set;
        @Generated
        private Set<SubscriptionEntity> subscriptions$value;
        @Generated
        private ApplicationEntity application;
        @Generated
        private Date expireAt;
        @Generated
        private Date createdAt;
        @Generated
        private Date updatedAt;
        @Generated
        private boolean revoked;
        @Generated
        private Date revokedAt;
        @Generated
        private boolean paused;
        @Generated
        private boolean expired;
        @Generated
        private Integer daysToExpirationOnLastNotification;

        @Generated
        ApiKeyEntityBuilder() {
        }

        @Generated
        public ApiKeyEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder key(String key) {
            this.key = key;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder subscriptions(Set<SubscriptionEntity> subscriptions) {
            this.subscriptions$value = subscriptions;
            this.subscriptions$set = true;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder application(ApplicationEntity application) {
            this.application = application;
            return this;
        }

        @JsonProperty(value="expire_at")
        @Generated
        public ApiKeyEntityBuilder expireAt(Date expireAt) {
            this.expireAt = expireAt;
            return this;
        }

        @JsonProperty(value="created_at")
        @Generated
        public ApiKeyEntityBuilder createdAt(Date createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @JsonProperty(value="updated_at")
        @Generated
        public ApiKeyEntityBuilder updatedAt(Date updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder revoked(boolean revoked) {
            this.revoked = revoked;
            return this;
        }

        @JsonProperty(value="revoked_at")
        @Generated
        public ApiKeyEntityBuilder revokedAt(Date revokedAt) {
            this.revokedAt = revokedAt;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder expired(boolean expired) {
            this.expired = expired;
            return this;
        }

        @Generated
        public ApiKeyEntityBuilder daysToExpirationOnLastNotification(Integer daysToExpirationOnLastNotification) {
            this.daysToExpirationOnLastNotification = daysToExpirationOnLastNotification;
            return this;
        }

        @Generated
        public ApiKeyEntity build() {
            Set<SubscriptionEntity> subscriptions$value = this.subscriptions$value;
            if (!this.subscriptions$set) {
                subscriptions$value = ApiKeyEntity.$default$subscriptions();
            }
            return new ApiKeyEntity(this.id, this.key, subscriptions$value, this.application, this.expireAt, this.createdAt, this.updatedAt, this.revoked, this.revokedAt, this.paused, this.expired, this.daysToExpirationOnLastNotification);
        }

        @Generated
        public String toString() {
            return "ApiKeyEntity.ApiKeyEntityBuilder(id=" + this.id + ", key=" + this.key + ", subscriptions$value=" + this.subscriptions$value + ", application=" + this.application + ", expireAt=" + this.expireAt + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", revoked=" + this.revoked + ", revokedAt=" + this.revokedAt + ", paused=" + this.paused + ", expired=" + this.expired + ", daysToExpirationOnLastNotification=" + this.daysToExpirationOnLastNotification + ")";
        }
    }
}

