/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.UserRoleEntity;
import io.gravitee.rest.api.model.search.Indexable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonIgnoreProperties(value={"displayName"}, allowGetters=true)
public class UserEntity
implements Indexable {
    private String id;
    private String firstname;
    private String lastname;
    private String password;
    private String email;
    private Set<UserRoleEntity> roles;
    private Map<String, Set<UserRoleEntity>> envRoles;
    @JsonProperty(value="created_at")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    private Date updatedAt;
    private String picture;
    private String source;
    private String sourceId;
    private Date lastConnectionAt;
    private Date firstConnectionAt;
    @JsonProperty(value="primary_owner")
    private boolean primaryOwner;
    private String status;
    private long loginCount;
    @JsonProperty(value="number_of_active_tokens")
    private int nbActiveTokens;
    private Boolean newsletterSubscribed;
    private Map<String, Object> customFields;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<UserRoleEntity> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<UserRoleEntity> roles) {
        this.roles = roles;
    }

    public Map<String, Set<UserRoleEntity>> getEnvRoles() {
        return this.envRoles;
    }

    public void setEnvRoles(Map<String, Set<UserRoleEntity>> envRoles) {
        this.envRoles = envRoles;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public Date getLastConnectionAt() {
        return this.lastConnectionAt;
    }

    public void setLastConnectionAt(Date lastConnectionAt) {
        this.lastConnectionAt = lastConnectionAt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public long getLoginCount() {
        return this.loginCount;
    }

    public void setLoginCount(long loginCount) {
        this.loginCount = loginCount;
    }

    public String getDisplayName() {
        String displayName = this.firstname != null && !this.firstname.isEmpty() || this.lastname != null && !this.lastname.isEmpty() ? (this.firstname != null && !this.firstname.isEmpty() ? this.firstname + (this.lastname != null && !this.lastname.isEmpty() ? ' ' + this.lastname : "") : this.lastname) : (this.email != null && !this.email.isEmpty() && !"memory".equals(this.source) ? this.email : this.sourceId);
        return displayName;
    }

    public boolean isPrimaryOwner() {
        return this.primaryOwner;
    }

    public void setPrimaryOwner(boolean primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    public int getNbActiveTokens() {
        return this.nbActiveTokens;
    }

    public void setNbActiveTokens(int nbActiveTokens) {
        this.nbActiveTokens = nbActiveTokens;
    }

    public Date getFirstConnectionAt() {
        return this.firstConnectionAt;
    }

    public void setFirstConnectionAt(Date firstConnectionAt) {
        this.firstConnectionAt = firstConnectionAt;
    }

    public Boolean getNewsletterSubscribed() {
        return this.newsletterSubscribed;
    }

    public void setNewsletterSubscribed(Boolean newsletterSubscribed) {
        this.newsletterSubscribed = newsletterSubscribed;
    }

    public Map<String, Object> getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(Map<String, Object> customFields) {
        this.customFields = customFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserEntity that = (UserEntity)o;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "UserEntity{id='" + this.id + '\'' + ", firstname='" + this.firstname + '\'' + ", lastname='" + this.lastname + '\'' + ", password='" + this.password + '\'' + ", email='" + this.email + '\'' + ", roles=" + this.roles + ", envRoles=" + this.envRoles + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", picture='" + this.picture + '\'' + ", source='" + this.source + '\'' + ", sourceId='" + this.sourceId + '\'' + ", lastConnectionAt=" + this.lastConnectionAt + ", primaryOwner=" + this.primaryOwner + ", status='" + this.status + '\'' + ", loginCount=" + this.loginCount + ", nbActiveTokens=" + this.nbActiveTokens + '}';
    }
}

