/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.permissions;

import io.gravitee.rest.api.model.permissions.ApiPermission;
import io.gravitee.rest.api.model.permissions.ApplicationPermission;
import io.gravitee.rest.api.model.permissions.EnvironmentPermission;
import io.gravitee.rest.api.model.permissions.GroupPermission;
import io.gravitee.rest.api.model.permissions.OrganizationPermission;
import io.gravitee.rest.api.model.permissions.RoleScope;

public interface Permission {
    default public String getName() {
        return null;
    }

    default public int getMask() {
        return -1;
    }

    public static Permission[] findByScope(RoleScope scope) {
        switch (scope) {
            case API: {
                return ApiPermission.values();
            }
            case APPLICATION: {
                return ApplicationPermission.values();
            }
            case GROUP: {
                return GroupPermission.values();
            }
            case ENVIRONMENT: {
                return EnvironmentPermission.values();
            }
            case ORGANIZATION: {
                return OrganizationPermission.values();
            }
        }
        throw new IllegalArgumentException("[" + (Object)((Object)scope) + "] are not a RolePermission");
    }

    public static Permission findByScopeAndName(RoleScope scope, String name) {
        for (Permission permission : Permission.findByScope(scope)) {
            if (!permission.getName().equals(name)) continue;
            return permission;
        }
        throw new IllegalArgumentException("[" + (Object)((Object)scope) + "] and [" + name + "] are not a RolePermission");
    }
}

