/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import io.gravitee.rest.api.model.EventType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class AlertEventQuery {
    private final long from;
    private final long to;
    private final int pageSize;
    private final int pageNumber;

    private AlertEventQuery(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.pageSize = builder.pageSize;
        this.pageNumber = builder.pageNumber;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlertEventQuery that = (AlertEventQuery)o;
        return this.from == that.from && this.to == that.to && this.pageSize == that.pageSize && this.pageNumber == that.pageNumber;
    }

    public int hashCode() {
        return Objects.hash(this.from, this.to, this.pageSize, this.pageNumber);
    }

    public String toString() {
        return "AlertEventQuery{, from=" + this.from + ", to=" + this.to + ", pageSize=" + this.pageSize + ", pageNumber=" + this.pageNumber + '}';
    }

    public static class Builder {
        private Map<String, Object> properties;
        private Collection<EventType> types;
        private long from;
        private long to;
        private int pageSize;
        private int pageNumber;

        public AlertEventQuery build() {
            return new AlertEventQuery(this);
        }

        public Builder property(String key, Object value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, Object>();
            }
            this.properties.put(key, value);
            return this;
        }

        public Builder type(EventType type) {
            this.types = Collections.singletonList(type);
            return this;
        }

        public Builder type(EventType ... types) {
            this.types = Arrays.asList(types);
            return this;
        }

        public Builder from(long from) {
            this.from = from;
            return this;
        }

        public Builder to(long to) {
            this.to = to;
            return this;
        }

        public Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder pageNumber(int pageNumber) {
            this.pageNumber = pageNumber;
            return this;
        }
    }
}

