/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.parameters;

import io.gravitee.rest.api.model.parameters.KeyScope;
import io.gravitee.rest.api.model.settings.ApiPrimaryOwnerMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Schema(enumAsRef=true)
public enum Key {
    COMPANY_NAME("company.name", "Gravitee.io", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_TOP_APIS("portal.top-apis", List.class, false, new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    PORTAL_ENTRYPOINT("portal.entrypoint", "https://api.company.com", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIKEY_HEADER("portal.apikey.header", "X-Gravitee-Api-Key", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_SUPPORT_ENABLED("portal.support.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RATING_ENABLED("portal.rating.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RATING_COMMENT_MANDATORY("portal.rating.comment.mandatory", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_USERCREATION_ENABLED("portal.userCreation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_USERCREATION_AUTOMATICVALIDATION_ENABLED("portal.userCreation.automaticValidation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_ANALYTICS_ENABLED("portal.analytics.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_ANALYTICS_TRACKINGID("portal.analytics.trackingId", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_TILESMODE_ENABLED("portal.apis.tilesMode.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_CATEGORY_ENABLED("portal.apis.categoryMode.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_PROMOTED_API_ENABLED("portal.apis.promotedApiMode.enabled", "true", Set.of(KeyScope.ENVIRONMENT)),
    PORTAL_APIS_SHOW_TAGS_IN_APIHEADER("portal.apis.apiheader.showtags.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_APIS_SHOW_CATEGORIES_IN_APIHEADER("portal.apis.apiheader.showcategories.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_UPLOAD_MEDIA_ENABLED("portal.uploadMedia.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_UPLOAD_MEDIA_MAXSIZE("portal.uploadMedia.maxSizeInOctet", "1000000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_URL("portal.url", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.SYSTEM))),
    PORTAL_HOMEPAGE_TITLE("portal.homepageTitle", new HashSet<KeyScope>(Collections.singletonList(KeyScope.ENVIRONMENT))),
    MANAGEMENT_TITLE("management.title", "Gravitee.io Management", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    MANAGEMENT_URL("management.url", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    THEME_NAME("theme.name", "default", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    THEME_LOGO("theme.logo", "themes/assets/gravitee-logo.svg", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    THEME_LOADER("theme.loader", "assets/gravitee_logo_anim.gif", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    THEME_CSS("theme.css", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_AUTHENTICATION_FORCELOGIN_ENABLED("portal.authentication.forceLogin.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_AUTHENTICATION_LOCALLOGIN_ENABLED("portal.authentication.localLogin.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_SCHEDULER_TASKS("portal.scheduler.tasks", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_SCHEDULER_NOTIFICATIONS("portal.scheduler.notifications", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    DOCUMENTATION_URL("documentation.url", "https://docs.gravitee.io", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_JWT_ENABLED("plan.security.jwt.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_OAUTH2_ENABLED("plan.security.oauth2.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_APIKEY_ENABLED("plan.security.apikey.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_APIKEY_CUSTOM_ALLOWED("plan.security.apikey.allowCustom.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_APIKEY_SHARED_ALLOWED("plan.security.apikey.allowShared.enabled", "false", Set.of(KeyScope.ENVIRONMENT, KeyScope.SYSTEM)),
    PLAN_SECURITY_KEYLESS_ENABLED("plan.security.keyless.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PLAN_SECURITY_SUBSCRIPTION_ENABLED("plan.security.subscription.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    OPEN_API_DOC_TYPE_SWAGGER_ENABLED("open.api.doc.type.swagger.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    OPEN_API_DOC_TYPE_REDOC_ENABLED("open.api.doc.type.redoc.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    OPEN_API_DOC_TYPE_DEFAULT("open.api.doc.type.default", "Swagger", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_ENABLED("api.quality.metrics.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_FUNCTIONAL_DOCUMENTATION_WEIGHT("api.quality.metrics.functional.documentation.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_TECHNICAL_DOCUMENTATION_WEIGHT("api.quality.metrics.technical.documentation.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_HEALTHCHECK_WEIGHT("api.quality.metrics.healthcheck.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_DESCRIPTION_WEIGHT("api.quality.metrics.description.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_DESCRIPTION_MIN_LENGTH("api.quality.metrics.description.min.length", "100", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_LOGO_WEIGHT("api.quality.metrics.logo.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_CATEGORIES_WEIGHT("api.quality.metrics.categories.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_QUALITY_METRICS_LABELS_WEIGHT("api.quality.metrics.labels.weight", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    ALERT_ENABLED("alert.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_DEFAULT_MAX_DURATION("logging.default.max.duration", "0", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_AUDIT_ENABLED("logging.audit.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_AUDIT_TRAIL_ENABLED("logging.audit.trail.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    LOGGING_USER_DISPLAYED("logging.user.displayed", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    ANALYTICS_CLIENT_TIMEOUT("analytics.client.timeout", "30000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_SIMPLE_ENABLED("application.types.simple.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_BROWSER_ENABLED("application.types.browser.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_WEB_ENABLED("application.types.web.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_NATIVE_ENABLED("application.types.native.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_TYPE_BACKEND_TO_BACKEND_ENABLED("application.types.backend_to_backend.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    APPLICATION_REGISTRATION_ENABLED("application.registration.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_REVIEW_ENABLED("api.review.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    MAINTENANCE_MODE_ENABLED("maintenance.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    NEWSLETTER_ENABLED("newsletter.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RECAPTCHA_ENABLED("portal.reCaptcha.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_RECAPTCHA_SITE_KEY("portal.reCaptcha.siteKey", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_ALLOW_ORIGIN("http.api.portal.cors.allow-origin", "*", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_ALLOW_HEADERS("http.api.portal.cors.allow-headers", "Cache-Control;Pragma;Origin;Authorization;Content-Type;X-Requested-With;If-Match;X-Xsrf-Token;X-Recaptcha-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_ALLOW_METHODS("http.api.portal.cors.allow-methods", "OPTIONS;GET;POST;PUT;DELETE;PATCH", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_EXPOSED_HEADERS("http.api.portal.cors.exposed-headers", "ETag;X-Xsrf-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    PORTAL_HTTP_CORS_MAX_AGE("http.api.portal.cors.max-age", "1728000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_ENABLED("email.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_HOST("email.host", "smtp.my.domain", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_PORT("email.port", "587", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_USERNAME("email.username", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_PASSWORD("email.password", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_PROTOCOL("email.protocol", "smtp", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_SUBJECT("email.subject", "[Gravitee.io] %s", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_FROM("email.from", "noreply@my.domain", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_PROPERTIES_AUTH_ENABLED("email.properties.auth", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_PROPERTIES_STARTTLS_ENABLE("email.properties.starttls.enable", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    EMAIL_PROPERTIES_SSL_TRUST("email.properties.ssl.trust", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_LABELS_DICTIONARY("api.labelsDictionary", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    API_PRIMARY_OWNER_MODE("api.primary.owner.mode", ApiPrimaryOwnerMode.HYBRID.name(), new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_AUTHENTICATION_LOCALLOGIN_ENABLED("console.authentication.localLogin.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SCHEDULER_TASKS("console.scheduler.tasks", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SCHEDULER_NOTIFICATIONS("console.scheduler.notifications", "10", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_RECAPTCHA_ENABLED("console.reCaptcha.enabled", "false", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_RECAPTCHA_SITE_KEY("console.reCaptcha.siteKey", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_ALLOW_ORIGIN("http.api.management.cors.allow-origin", "*", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_ALLOW_HEADERS("http.api.management.cors.allow-headers", "Cache-Control;Pragma;Origin;Authorization;Content-Type;X-Requested-With;If-Match;X-Xsrf-Token;X-Recaptcha-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_ALLOW_METHODS("http.api.management.cors.allow-methods", "OPTIONS;GET;POST;PUT;DELETE;PATCH", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_EXPOSED_HEADERS("http.api.management.cors.exposed-headers", "ETag;X-Xsrf-Token", List.class, new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_HTTP_CORS_MAX_AGE("http.api.management.cors.max-age", "1728000", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_USERCREATION_ENABLED("console.userCreation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_USERCREATION_AUTOMATICVALIDATION_ENABLED("console.userCreation.automaticValidation.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_SUPPORT_ENABLED("console.support.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_DASHBOARDS_API_STATUS("console.dashboards.apiStatus.enabled", "true", new HashSet<KeyScope>(Arrays.asList(KeyScope.ENVIRONMENT, KeyScope.ORGANIZATION, KeyScope.SYSTEM))),
    CONSOLE_PATH_BASED_API_CREATION_ENABLED("console.pathBasedApiCreation.enabled", "false", Set.of(KeyScope.ORGANIZATION, KeyScope.SYSTEM)),
    CONSOLE_SYSTEM_ROLE_EDITION_ENABLED("console.systemRoleEdition.enabled", "false", Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_ENABLED("console.analytics.pendo.enabled", "false", Set.of(KeyScope.SYSTEM)),
    CONSOLE_ANALYTICS_PENDO_API_KEY("console.analytics.pendo.apiKey", "", Set.of(KeyScope.SYSTEM)),
    JUPITER_MODE_ENABLED("api.jupiterMode.enabled", "false", Set.of(KeyScope.SYSTEM)),
    JUPITER_MODE_DEFAULT("api.jupiterMode.default", "never", Set.of(KeyScope.SYSTEM));

    String key;
    String defaultValue;
    Class<?> type;
    boolean isOverridable = true;
    Set<KeyScope> scopes;

    private Key(String key, Set<KeyScope> scopes) {
        this.key = key;
        this.scopes = scopes;
    }

    private Key(String key, String defaultValue, Class<?> type, Set<KeyScope> scopes) {
        this.key = key;
        this.type = type;
        this.defaultValue = defaultValue;
        this.scopes = scopes;
    }

    private Key(String key, Class<?> type, Set<KeyScope> scopes) {
        this.key = key;
        this.type = type;
        this.scopes = scopes;
    }

    private Key(String key, Class<?> type, boolean isOverridable, Set<KeyScope> scopes) {
        this.key = key;
        this.type = type;
        this.isOverridable = isOverridable;
        this.scopes = scopes;
    }

    private Key(String key, String defaultValue, Set<KeyScope> scopes) {
        this.key = key;
        this.defaultValue = defaultValue;
        this.scopes = scopes;
    }

    public static Key findByKey(String value) {
        for (Key key : Key.values()) {
            if (!key.key.equals(value)) continue;
            return key;
        }
        throw new IllegalArgumentException(value + " is not a valid Key");
    }

    public String key() {
        return this.key;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public Class<?> type() {
        return this.type;
    }

    public boolean isOverridable() {
        return this.isOverridable;
    }

    public Set<KeyScope> scopes() {
        return this.scopes;
    }
}

