/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.api;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.gravitee.common.component.Lifecycle;
import io.gravitee.definition.model.DefinitionContext;
import io.gravitee.definition.model.DefinitionVersion;
import io.gravitee.definition.model.ExecutionMode;
import io.gravitee.definition.model.FlowMode;
import io.gravitee.definition.model.Properties;
import io.gravitee.definition.model.Property;
import io.gravitee.definition.model.Proxy;
import io.gravitee.definition.model.ResponseTemplate;
import io.gravitee.definition.model.Rule;
import io.gravitee.definition.model.flow.Flow;
import io.gravitee.definition.model.plugins.resources.Resource;
import io.gravitee.definition.model.services.Services;
import io.gravitee.rest.api.model.DeploymentRequired;
import io.gravitee.rest.api.model.PlanEntity;
import io.gravitee.rest.api.model.PrimaryOwnerEntity;
import io.gravitee.rest.api.model.Visibility;
import io.gravitee.rest.api.model.WorkflowState;
import io.gravitee.rest.api.model.api.ApiEntrypointEntity;
import io.gravitee.rest.api.model.api.ApiLifecycleState;
import io.gravitee.rest.api.model.v4.api.GenericApiEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.NotNull;
import lombok.Generated;

@JsonFilter(value="apiMembershipTypeFilter")
public class ApiEntity
implements GenericApiEntity {
    @Schema(description="API's uuid.", example="00f8c9e7-78fc-4907-b8c9-e778fc790750")
    private String id;
    @Schema(description="API's crossId. Identifies API across environments.", example="df83b2a4-cc3e-3f80-9f0d-c138c106c076")
    private String crossId;
    @Schema(description="API's name. Duplicate names can exists.", example="My Api")
    private String name;
    @Schema(description="Api's version. It's a simple string only used in the portal.", example="v1.0")
    private String version;
    @Schema(description="API's description. A short description of your API.", example="I can use a hundred characters to describe this API.")
    private String description;
    @Schema(description="Api's execution mode. Define if the execution mode should use v3 or jupiter mode.", example="v3")
    @DeploymentRequired
    @JsonProperty(value="execution_mode")
    private ExecutionMode executionMode;
    @Schema(description="API's groups. Used to add team in your API.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @JsonProperty(value="context_path")
    @Schema(description="API's context path.", example="/my-awesome-api")
    private String contextPath;
    @NotNull
    @DeploymentRequired
    @JsonProperty(value="proxy", required=true)
    @Schema(description="API's definition.")
    private Proxy proxy;
    @DeploymentRequired
    @JsonProperty(value="flow_mode")
    @Schema(description="API's flow mode.", example="BEST_MATCH")
    private FlowMode flowMode;
    @DeploymentRequired
    @JsonProperty(value="paths")
    @Schema(description="a map where you can associate a path to a configuration (the policies configuration)")
    private Map<String, List<Rule>> paths = new HashMap<String, List<Rule>>();
    @DeploymentRequired
    @JsonProperty(value="flows")
    @Schema(description="a list of flows (the policies configuration)")
    private List<Flow> flows = new ArrayList<Flow>();
    @DeploymentRequired
    @JsonProperty(value="plans")
    @Schema(description="a list of plans with flows (the policies configuration)")
    private Set<PlanEntity> plans = new HashSet<PlanEntity>();
    @DeploymentRequired
    @JsonProperty(value="gravitee")
    @Schema(description="API's gravitee definition version")
    private String graviteeDefinitionVersion;
    @JsonProperty(value="definition_context")
    @Schema(description="the context where the api definition was created from")
    private DefinitionContext definitionContext;
    @JsonProperty(value="deployed_at")
    @Schema(description="The last date (as timestamp) when the API was deployed.", example="1581256457163")
    private Date deployedAt;
    @JsonProperty(value="created_at")
    @Schema(description="The date (as a timestamp) when the API was created.", example="1581256457163")
    private Date createdAt;
    @JsonProperty(value="updated_at")
    @Schema(description="The last date (as a timestamp) when the API was updated.", example="1581256457163")
    private Date updatedAt;
    @Schema(description="The visibility of the API regarding the portal.", example="PUBLIC")
    private Visibility visibility;
    @Schema(description="The status of the API regarding the gateway.", example="STARTED")
    private Lifecycle.State state;
    @JsonProperty(value="owner")
    @Schema(description="The user with role PRIMARY_OWNER on this API.")
    private PrimaryOwnerEntity primaryOwner;
    @DeploymentRequired
    @JsonProperty(value="properties")
    @Schema(description="A dictionary (could be dynamic) of properties available in the API context.")
    private Properties properties;
    @DeploymentRequired
    @JsonProperty(value="services")
    @Schema(description="The configuration of API services like the dynamic properties, the endpoint discovery or the healthcheck.")
    private Services services;
    @DeploymentRequired
    @Schema(description="the list of sharding tags associated with this API.", example="public, private")
    private Set<String> tags;
    @Schema(description="the API logo encoded in base64")
    private String picture;
    @JsonProperty(value="picture_url")
    @Schema(description="the API logo url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/picture")
    private String pictureUrl;
    @DeploymentRequired
    @JsonProperty(value="resources")
    @Schema(description="The list of API resources used by policies like cache resources or oauth2")
    private List<Resource> resources = new ArrayList<Resource>();
    @Schema(description="the list of categories associated with this API", example="Product, Customer, Misc")
    private Set<String> categories;
    @Schema(description="the free list of labels associated with this API", example="json, read_only, awesome")
    private List<String> labels;
    @DeploymentRequired
    @JsonProperty(value="path_mappings")
    @Schema(description="A list of paths used to aggregate data in analytics", example="/products/:productId, /products/:productId/media")
    private Set<String> pathMappings = new HashSet<String>();
    @JsonIgnore
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @DeploymentRequired
    @JsonProperty(value="response_templates")
    @Schema(description="A map that allows you to configure the output of a request based on the event throws by the gateway. Example : Quota exceeded, api-ky is missing, ...")
    private Map<String, Map<String, ResponseTemplate>> responseTemplates;
    @JsonProperty(value="lifecycle_state")
    private ApiLifecycleState lifecycleState;
    @JsonProperty(value="workflow_state")
    private WorkflowState workflowState;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    private List<ApiEntrypointEntity> entrypoints;
    @Schema(description="the API background encoded in base64")
    private String background;
    @JsonProperty(value="background_url")
    @Schema(description="the API background url.", example="https://gravitee.mycompany.com/management/apis/6c530064-0b2c-4004-9300-640b2ce0047b/background")
    private String backgroundUrl;
    @JsonIgnore
    private String referenceType;
    @JsonIgnore
    private String referenceId;

    @JsonIgnore
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @JsonGetter(value="properties")
    public List<Property> getPropertyList() {
        if (this.properties != null) {
            return this.properties.getProperties();
        }
        return Collections.emptyList();
    }

    @JsonSetter(value="properties")
    public void setPropertyList(List<Property> properties) {
        this.properties = new Properties();
        this.properties.setProperties(properties);
    }

    @Override
    @JsonIgnore
    public String getApiVersion() {
        return this.version;
    }

    @Override
    @JsonIgnore
    public DefinitionVersion getDefinitionVersion() {
        if (this.graviteeDefinitionVersion != null) {
            return DefinitionVersion.valueOfLabel((String)this.graviteeDefinitionVersion);
        }
        return null;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getCrossId() {
        return this.crossId;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public ExecutionMode getExecutionMode() {
        return this.executionMode;
    }

    @Override
    @Generated
    public Set<String> getGroups() {
        return this.groups;
    }

    @Generated
    public String getContextPath() {
        return this.contextPath;
    }

    @NotNull
    @Generated
    public Proxy getProxy() {
        return this.proxy;
    }

    @Generated
    public FlowMode getFlowMode() {
        return this.flowMode;
    }

    @Generated
    public Map<String, List<Rule>> getPaths() {
        return this.paths;
    }

    @Generated
    public List<Flow> getFlows() {
        return this.flows;
    }

    @Generated
    public Set<PlanEntity> getPlans() {
        return this.plans;
    }

    @Generated
    public String getGraviteeDefinitionVersion() {
        return this.graviteeDefinitionVersion;
    }

    @Override
    @Generated
    public DefinitionContext getDefinitionContext() {
        return this.definitionContext;
    }

    @Override
    @Generated
    public Date getDeployedAt() {
        return this.deployedAt;
    }

    @Override
    @Generated
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Generated
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    @Generated
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @Generated
    public Lifecycle.State getState() {
        return this.state;
    }

    @Override
    @Generated
    public PrimaryOwnerEntity getPrimaryOwner() {
        return this.primaryOwner;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public Services getServices() {
        return this.services;
    }

    @Override
    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @Generated
    public String getPicture() {
        return this.picture;
    }

    @Generated
    public String getPictureUrl() {
        return this.pictureUrl;
    }

    @Generated
    public List<Resource> getResources() {
        return this.resources;
    }

    @Override
    @Generated
    public Set<String> getCategories() {
        return this.categories;
    }

    @Override
    @Generated
    public List<String> getLabels() {
        return this.labels;
    }

    @Generated
    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    @Override
    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Map<String, Map<String, ResponseTemplate>> getResponseTemplates() {
        return this.responseTemplates;
    }

    @Override
    @Generated
    public ApiLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    @Generated
    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    @Override
    @Generated
    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    @Generated
    public List<ApiEntrypointEntity> getEntrypoints() {
        return this.entrypoints;
    }

    @Generated
    public String getBackground() {
        return this.background;
    }

    @Generated
    public String getBackgroundUrl() {
        return this.backgroundUrl;
    }

    @Override
    @Generated
    public String getReferenceType() {
        return this.referenceType;
    }

    @Override
    @Generated
    public String getReferenceId() {
        return this.referenceId;
    }

    @Override
    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setCrossId(String crossId) {
        this.crossId = crossId;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="execution_mode")
    @Generated
    public void setExecutionMode(ExecutionMode executionMode) {
        this.executionMode = executionMode;
    }

    @Generated
    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    @JsonProperty(value="context_path")
    @Generated
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @JsonProperty(value="proxy", required=true)
    @Generated
    public void setProxy(@NotNull Proxy proxy) {
        this.proxy = proxy;
    }

    @JsonProperty(value="flow_mode")
    @Generated
    public void setFlowMode(FlowMode flowMode) {
        this.flowMode = flowMode;
    }

    @JsonProperty(value="paths")
    @Generated
    public void setPaths(Map<String, List<Rule>> paths) {
        this.paths = paths;
    }

    @JsonProperty(value="flows")
    @Generated
    public void setFlows(List<Flow> flows) {
        this.flows = flows;
    }

    @JsonProperty(value="plans")
    @Generated
    public void setPlans(Set<PlanEntity> plans) {
        this.plans = plans;
    }

    @JsonProperty(value="gravitee")
    @Generated
    public void setGraviteeDefinitionVersion(String graviteeDefinitionVersion) {
        this.graviteeDefinitionVersion = graviteeDefinitionVersion;
    }

    @JsonProperty(value="definition_context")
    @Generated
    public void setDefinitionContext(DefinitionContext definitionContext) {
        this.definitionContext = definitionContext;
    }

    @JsonProperty(value="deployed_at")
    @Generated
    public void setDeployedAt(Date deployedAt) {
        this.deployedAt = deployedAt;
    }

    @JsonProperty(value="created_at")
    @Generated
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    @JsonProperty(value="updated_at")
    @Generated
    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    @Generated
    public void setState(Lifecycle.State state) {
        this.state = state;
    }

    @JsonProperty(value="owner")
    @Generated
    public void setPrimaryOwner(PrimaryOwnerEntity primaryOwner) {
        this.primaryOwner = primaryOwner;
    }

    @JsonProperty(value="services")
    @Generated
    public void setServices(Services services) {
        this.services = services;
    }

    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public void setPicture(String picture) {
        this.picture = picture;
    }

    @JsonProperty(value="picture_url")
    @Generated
    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    @JsonProperty(value="resources")
    @Generated
    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    @Generated
    public void setCategories(Set<String> categories) {
        this.categories = categories;
    }

    @Generated
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    @JsonProperty(value="path_mappings")
    @Generated
    public void setPathMappings(Set<String> pathMappings) {
        this.pathMappings = pathMappings;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @JsonProperty(value="response_templates")
    @Generated
    public void setResponseTemplates(Map<String, Map<String, ResponseTemplate>> responseTemplates) {
        this.responseTemplates = responseTemplates;
    }

    @JsonProperty(value="lifecycle_state")
    @Generated
    public void setLifecycleState(ApiLifecycleState lifecycleState) {
        this.lifecycleState = lifecycleState;
    }

    @JsonProperty(value="workflow_state")
    @Generated
    public void setWorkflowState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @JsonProperty(value="disable_membership_notifications")
    @Generated
    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    @Generated
    public void setEntrypoints(List<ApiEntrypointEntity> entrypoints) {
        this.entrypoints = entrypoints;
    }

    @Generated
    public void setBackground(String background) {
        this.background = background;
    }

    @JsonProperty(value="background_url")
    @Generated
    public void setBackgroundUrl(String backgroundUrl) {
        this.backgroundUrl = backgroundUrl;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    @Override
    @JsonIgnore
    @Generated
    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    @Generated
    public String toString() {
        return "ApiEntity(id=" + this.getId() + ", crossId=" + this.getCrossId() + ", name=" + this.getName() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", executionMode=" + this.getExecutionMode() + ", groups=" + this.getGroups() + ", contextPath=" + this.getContextPath() + ", proxy=" + this.getProxy() + ", flowMode=" + this.getFlowMode() + ", paths=" + this.getPaths() + ", flows=" + this.getFlows() + ", plans=" + this.getPlans() + ", graviteeDefinitionVersion=" + this.getGraviteeDefinitionVersion() + ", definitionContext=" + this.getDefinitionContext() + ", deployedAt=" + this.getDeployedAt() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", visibility=" + this.getVisibility() + ", state=" + this.getState() + ", primaryOwner=" + this.getPrimaryOwner() + ", properties=" + this.getProperties() + ", services=" + this.getServices() + ", tags=" + this.getTags() + ", picture=" + this.getPicture() + ", pictureUrl=" + this.getPictureUrl() + ", resources=" + this.getResources() + ", categories=" + this.getCategories() + ", labels=" + this.getLabels() + ", pathMappings=" + this.getPathMappings() + ", metadata=" + this.getMetadata() + ", responseTemplates=" + this.getResponseTemplates() + ", lifecycleState=" + this.getLifecycleState() + ", workflowState=" + this.getWorkflowState() + ", disableMembershipNotifications=" + this.isDisableMembershipNotifications() + ", entrypoints=" + this.getEntrypoints() + ", background=" + this.getBackground() + ", backgroundUrl=" + this.getBackgroundUrl() + ", referenceType=" + this.getReferenceType() + ", referenceId=" + this.getReferenceId() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiEntity)) {
            return false;
        }
        ApiEntity other = (ApiEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ApiEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

