/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model.subscription;

import io.gravitee.rest.api.model.SubscriptionEntity;
import io.gravitee.rest.api.model.api.ApiEntity;
import io.gravitee.rest.api.model.pagedresult.Metadata;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;

public class SubscriptionMetadataQuery {
    private String organization;
    private String environment;
    private Collection<SubscriptionEntity> subscriptions;
    private boolean withApplications = false;
    private boolean withPlans = false;
    private boolean withApis = false;
    private boolean withSubscribers = false;
    private boolean details = false;
    private Map<DelegateType, List<BiFunction>> delegates = new HashMap<DelegateType, List<BiFunction>>();

    public SubscriptionMetadataQuery(String organization, String environment, Collection<SubscriptionEntity> subscriptions) {
        this.organization = organization;
        this.environment = environment;
        this.subscriptions = subscriptions;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public Collection<SubscriptionEntity> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Collection<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public Optional<Boolean> ifApplications() {
        return this.ifTrue(this.withApplications);
    }

    private Optional<Boolean> ifTrue(boolean feature) {
        if (feature) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    public SubscriptionMetadataQuery withApplications(boolean withApplications) {
        this.withApplications = withApplications;
        return this;
    }

    public Optional<Boolean> ifPlans() {
        return this.ifTrue(this.withPlans);
    }

    public SubscriptionMetadataQuery withPlans(boolean withPlans) {
        this.withPlans = withPlans;
        return this;
    }

    public Optional<Boolean> ifApis() {
        return this.ifTrue(this.withApis);
    }

    public SubscriptionMetadataQuery withApis(boolean withApis) {
        this.withApis = withApis;
        return this;
    }

    public Optional<Boolean> ifSubscribers() {
        return this.ifTrue(this.withSubscribers);
    }

    public SubscriptionMetadataQuery withSubscribers(boolean withSubscribers) {
        this.withSubscribers = withSubscribers;
        return this;
    }

    public boolean hasDetails() {
        return this.details;
    }

    public SubscriptionMetadataQuery excludeDetails() {
        this.details = false;
        return this;
    }

    public SubscriptionMetadataQuery includeDetails() {
        this.details = true;
        return this;
    }

    public SubscriptionMetadataQuery fillMetadata(DelegateType type, BiFunction<Metadata, ?, ?> ... delegate) {
        this.delegates.put(type, Arrays.asList(delegate));
        return this;
    }

    public SubscriptionMetadataQuery fillApiMetadata(BiFunction<Metadata, ApiEntity, ApiEntity> ... delegate) {
        return this.fillMetadata(DelegateType.API, delegate);
    }

    public List<BiFunction> getApiDelegate() {
        if (this.delegates.containsKey((Object)DelegateType.API)) {
            return this.delegates.get((Object)DelegateType.API);
        }
        return Collections.emptyList();
    }

    @Schema(enumAsRef=true)
    public static enum DelegateType {
        API;

    }
}

