/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;

@Schema(enumAsRef=true)
public enum PageType {
    ASCIIDOC(List.of("adoc"), 200, null),
    ASYNCAPI(List.of("json", "yaml", "yml"), 200, "(?s).*\\\"?asyncapi\\\"?: *['\\\"]?\\d.*"),
    MARKDOWN(List.of("md", "markdown"), 200, null),
    MARKDOWN_TEMPLATE(Collections.emptyList(), 200, null),
    SWAGGER(List.of("json", "yaml", "yml"), 200, "(?s).*\\\"?(swagger|openapi)\\\"?: *['\\\"]?\\d.*"),
    FOLDER(Collections.emptyList(), 300, null),
    LINK(Collections.emptyList(), 100, null),
    ROOT(Collections.emptyList(), 500, null),
    SYSTEM_FOLDER(Collections.emptyList(), 400, null),
    TRANSLATION(Collections.emptyList(), 0, null);

    List<String> extensions;
    Integer removeOrder;
    String contentRegexp;

    private PageType(List<String> extensions, Integer removeOrder, String contentRegexp) {
        this.extensions = extensions;
        this.removeOrder = removeOrder;
        this.contentRegexp = contentRegexp;
    }

    public Integer getRemoveOrder() {
        return this.removeOrder;
    }

    public boolean matchesExtension(String pageExtension) {
        return this.extensions.contains(pageExtension.toLowerCase());
    }

    public boolean matchesExtensionAndContent(String pageExtension, String pageContent) {
        return this.matchesExtension(pageExtension) && (this.contentRegexp == null || pageContent.matches(this.contentRegexp));
    }

    public static PageType fromPageExtensionAndContent(String pageExtension, String pageContent) {
        return Stream.of(PageType.values()).filter(pageType -> pageType.matchesExtensionAndContent(pageExtension, pageContent)).findFirst().orElse(null);
    }
}

