/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.rest.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.gravitee.rest.api.model.application.ApplicationSettings;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UpdateApplicationEntity {
    @NotNull(message="Application's name must not be null")
    @NotEmpty(message="Application's name must not be empty")
    @ApiModelProperty(value="Application's name. Duplicate names can exists.", example="My App")
    private @NotNull(message="Application's name must not be null") @NotEmpty(message="Application's name must not be empty") String name;
    @NotNull(message="Application's description must not be null")
    @ApiModelProperty(value="Application's description. A short description of your App.", example="I can use a hundred characters to describe this App.")
    private @NotNull(message="Application's description must not be null") String description;
    private String picture;
    @JsonProperty(value="picture_url")
    private String pictureUrl;
    @NotNull(message="Application's settings must not be null")
    private @NotNull(message="Application's settings must not be null") ApplicationSettings settings;
    @ApiModelProperty(value="Application's groups. Used to add team in your App.", example="['MY_GROUP1', 'MY_GROUP2']")
    private Set<String> groups;
    @Deprecated
    @ApiModelProperty(value="a string to describe the type of your app.", example="iOS")
    private String type;
    @Deprecated
    private String clientId;
    @JsonProperty(value="disable_membership_notifications")
    private boolean disableMembershipNotifications;
    private String background;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public ApplicationSettings getSettings() {
        return this.settings;
    }

    public void setSettings(ApplicationSettings settings) {
        this.settings = settings;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public boolean isDisableMembershipNotifications() {
        return this.disableMembershipNotifications;
    }

    public void setDisableMembershipNotifications(boolean disableMembershipNotifications) {
        this.disableMembershipNotifications = disableMembershipNotifications;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Application{");
        sb.append("description='").append(this.description).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", groups='").append(this.groups).append('\'');
        sb.append(", disableMembershipNotifications='").append(this.disableMembershipNotifications);
        sb.append('}');
        return sb.toString();
    }
}

