/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.entrypoint.internal;

import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.ConfigurablePluginManager;
import io.gravitee.plugin.core.api.Plugin;
import io.gravitee.plugin.entrypoint.EntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.internal.DefaultEntrypointConnectorPlugin;
import io.gravitee.plugin.entrypoint.internal.EntrypointConnectorConfigurationClassFinder;
import java.net.URLClassLoader;
import org.springframework.beans.factory.annotation.Autowired;

public class EntrypointConnectorPluginHandler
extends AbstractSimplePluginHandler<EntrypointConnectorPlugin<?>> {
    @Autowired
    private ConfigurablePluginManager<EntrypointConnectorPlugin<?>> entrypointPluginManager;

    public boolean canHandle(Plugin plugin) {
        return "entrypoint-connector".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "entrypoint-connector";
    }

    protected EntrypointConnectorPlugin<?> create(Plugin plugin, Class<?> pluginClass) {
        Class configurationClass = new EntrypointConnectorConfigurationClassFinder().lookupFirst(pluginClass);
        return new DefaultEntrypointConnectorPlugin(plugin, pluginClass, configurationClass);
    }

    protected void register(EntrypointConnectorPlugin<?> entrypointConnectorPlugin) {
        this.entrypointPluginManager.register(entrypointConnectorPlugin);
        try {
            URLClassLoader classLoader = (URLClassLoader)entrypointConnectorPlugin.entrypointConnectorFactory().getClassLoader();
            classLoader.close();
        }
        catch (Exception e) {
            this.logger.error("Unexpected exception while trying to release the connector classloader");
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }
}

