/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.tcp.proxy.client;

import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.tcp.VertxTcpClient;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorSharedConfiguration;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.net.NetClient;
import java.util.concurrent.atomic.AtomicBoolean;

public class TcpClientFactory {
    private NetClient tcpClient;
    private final AtomicBoolean tcpClientCreated = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetClient getOrBuildTcpClient(ExecutionContext ctx, TcpProxyEndpointConnectorConfiguration configuration, TcpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        if (this.tcpClient == null) {
            TcpClientFactory tcpClientFactory = this;
            synchronized (tcpClientFactory) {
                if (this.tcpClientCreated.compareAndSet(false, true)) {
                    this.tcpClient = this.buildTcpClient(ctx, configuration, sharedConfiguration).build().createTcpClient();
                }
            }
        }
        return this.tcpClient;
    }

    protected VertxTcpClient.VertxTcpClientBuilder buildTcpClient(ExecutionContext ctx, TcpProxyEndpointConnectorConfiguration configuration, TcpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        return VertxTcpClient.builder().vertx((Vertx)ctx.getComponent(Vertx.class)).tcpTarget(configuration.getTcpTarget()).sslOptions(sharedConfiguration.getSslOptions()).proxyOptions(sharedConfiguration.getProxyOptions()).nodeConfiguration((Configuration)ctx.getComponent(Configuration.class));
    }

    public void close() {
        if (this.tcpClient != null) {
            this.tcpClient.close();
            this.tcpClient = null;
        }
    }
}

