/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.tcp.proxy;

import io.gravitee.common.service.AbstractService;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.reactive.api.ApiType;
import io.gravitee.gateway.reactive.api.ConnectorMode;
import io.gravitee.gateway.reactive.api.connector.Connector;
import io.gravitee.gateway.reactive.api.connector.endpoint.EndpointConnector;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.tcp.reactive.VertxReadStreamUtil;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.tcp.proxy.configuration.TcpProxyEndpointConnectorSharedConfiguration;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.vertx.core.net.NetClientOptions;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.net.NetClient;
import io.vertx.rxjava3.core.streams.WriteStream;
import java.util.Set;

public class TcpProxyEndpointConnector
extends AbstractService<Connector>
implements EndpointConnector {
    private static final String ENDPOINT_ID = "tcp-proxy";
    static final Set<ConnectorMode> SUPPORTED_MODES = Set.of(ConnectorMode.SOCKET);
    private final TcpProxyEndpointConnectorConfiguration config;
    private final TcpProxyEndpointConnectorSharedConfiguration sharedConfig;

    TcpProxyEndpointConnector(TcpProxyEndpointConnectorConfiguration config, TcpProxyEndpointConnectorSharedConfiguration sharedConfig) {
        this.config = config;
        this.sharedConfig = sharedConfig;
    }

    public String id() {
        return ENDPOINT_ID;
    }

    public ApiType supportedApi() {
        return ApiType.PROXY;
    }

    public Set<ConnectorMode> supportedModes() {
        return SUPPORTED_MODES;
    }

    public Completable connect(ExecutionContext ctx) {
        Vertx vertx = (Vertx)ctx.getComponent(Vertx.class);
        NetClient client = vertx.createNetClient(this.buildNetClientOptions());
        return client.rxConnect(this.config.getTcpTarget().getPort(), this.config.getTcpTarget().getHost()).doOnSuccess(backendSocket -> {
            backendSocket.pause();
            ctx.response().chunks(backendSocket.toFlowable().map(Buffer::buffer));
            ctx.request().pipeUpstream(VertxReadStreamUtil.toVertxRxReadStream((Flowable)ctx.request().chunks()).rxPipeTo((WriteStream)backendSocket));
        }).ignoreElement();
    }

    private NetClientOptions buildNetClientOptions() {
        NetClientOptions options = new NetClientOptions().setMetricsName("tcp-client");
        if (this.sharedConfig.getTcpClientOptions() != null) {
            options.setConnectTimeout(this.sharedConfig.getTcpClientOptions().getConnectTimeout()).setReconnectAttempts(this.sharedConfig.getTcpClientOptions().getReconnectAttempts()).setReconnectInterval((long)this.sharedConfig.getTcpClientOptions().getReconnectInterval());
        }
        if (this.sharedConfig.getSslOptions() != null) {
            options.setTrustAll(this.sharedConfig.getSslOptions().isTrustAll());
            if (!this.sharedConfig.getSslOptions().isTrustAll()) {
                // empty if block
            }
        }
        return options;
    }

    TcpProxyEndpointConnectorConfiguration getConfig() {
        return this.config;
    }

    TcpProxyEndpointConnectorSharedConfiguration getSharedConfig() {
        return this.sharedConfig;
    }
}

