/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.configuration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.common.http.HttpHeader;
import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.DeploymentContext;
import io.gravitee.gateway.reactive.api.context.base.BaseExecutionContext;
import io.gravitee.gateway.reactive.api.context.http.HttpPlainExecutionContext;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.secrets.api.el.FieldKind;
import io.gravitee.secrets.api.el.SecretFieldAccessControl;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyEndpointConnectorConfigurationEvaluator {
    private static final String FAILURE_CONFIGURATION_INVALID = "FAILURE_CONFIGURATION_INVALID";
    private final Logger logger = LoggerFactory.getLogger(HttpProxyEndpointConnectorConfigurationEvaluator.class);
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpProxyEndpointConnectorConfiguration configuration;
    private static final Validator validator;
    private final String attributePrefix = "gravitee.attributes.endpoint.httpProxy";
    private final String internalId;

    public HttpProxyEndpointConnectorConfigurationEvaluator(HttpProxyEndpointConnectorConfiguration configuration) {
        this.configuration = configuration;
        this.internalId = UUID.randomUUID().toString();
    }

    private String buildAttributeName(String attributePrefix, String name) {
        return attributePrefix.concat(".").concat(name);
    }

    private String buildFieldName(String attributeName) {
        return attributeName.substring(this.attributePrefix.length() + 1);
    }

    private Maybe<String> evalStringProperty(String name, String value, String attributePrefix, BaseExecutionContext ctx, String secretKind) {
        String attributeName = this.buildAttributeName(attributePrefix, name);
        String attribute = (String)ctx.getAttribute(attributeName);
        if (attribute != null) {
            value = attribute;
        }
        if (value == null) {
            return Maybe.empty();
        }
        SecretFieldAccessControl accessControl = secretKind.isEmpty() ? new SecretFieldAccessControl(false, null, null) : new SecretFieldAccessControl(true, FieldKind.valueOf((String)secretKind), this.buildFieldName(attributeName));
        String finalValue = value;
        return ctx.getTemplateEngine().eval(value, String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, (Object)finalValue));
    }

    private Maybe<String> evalStringProperty(String name, String value, String attributePrefix, DeploymentContext ctx, String secretKind) {
        if (value == null) {
            return Maybe.empty();
        }
        String property = this.buildFieldName(this.buildAttributeName(attributePrefix, name));
        SecretFieldAccessControl accessControl = secretKind.isEmpty() ? new SecretFieldAccessControl(false, null, null) : new SecretFieldAccessControl(true, FieldKind.valueOf((String)secretKind), property);
        return ctx.getTemplateEngine().eval(value, String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)property, (Object)value));
    }

    private <T extends Enum<T>> T evalEnumProperty(String name, T value, Class<T> enumClass, String attributePrefix, BaseExecutionContext ctx) {
        String attribute = (String)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return Enum.valueOf(enumClass, attribute);
        }
        return value;
    }

    private Integer evalIntegerProperty(String name, Integer value, String attributePrefix, BaseExecutionContext ctx) {
        Integer attribute = (Integer)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private Long evalLongProperty(String name, Long value, String attributePrefix, BaseExecutionContext ctx) {
        Long attribute = (Long)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private Boolean evalBooleanProperty(String name, Boolean value, String attributePrefix, BaseExecutionContext ctx) {
        Boolean attribute = (Boolean)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private <T> Set<T> evalSetProperty(String name, Set<T> value, String attributePrefix, BaseExecutionContext ctx) {
        block3: {
            try {
                Set attribute = (Set)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
                if (attribute != null) {
                    return attribute;
                }
            }
            catch (ClassCastException cce) {
                List attribute = ctx.getAttributeAsList(this.buildAttributeName(attributePrefix, name));
                if (attribute == null) break block3;
                return Set.copyOf(attribute);
            }
        }
        return value;
    }

    private <T> List<T> evalListProperty(String name, List<T> value, String attributePrefix, BaseExecutionContext ctx) {
        List attribute = ctx.getAttributeAsList(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            return attribute;
        }
        return value;
    }

    private Maybe<List<String>> evalListStringProperty(String name, List<String> value, String attributePrefix, BaseExecutionContext ctx) {
        List attribute = ctx.getAttributeAsList(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            value = attribute;
        }
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable((Iterable)value).filter(Objects::nonNull).flatMapMaybe(v -> ctx.getTemplateEngine().eval(v, String.class).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, v))).toList().toMaybe();
    }

    private Maybe<List<String>> evalListStringProperty(String name, List<String> value, String attributePrefix, DeploymentContext ctx) {
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(value).filter(Objects::nonNull).flatMapMaybe(v -> ctx.getTemplateEngine().eval(v, String.class).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, v))).toList().toMaybe();
    }

    private Maybe<List<HttpHeader>> evalListHeaderProperty(String name, List<HttpHeader> headers, String attributePrefix, BaseExecutionContext ctx) {
        String attributeName = this.buildAttributeName(attributePrefix, name);
        List attribute = (List)ctx.getAttribute(attributeName);
        if (attribute != null) {
            headers = attribute;
        }
        if (headers == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable((Iterable)headers).filter(Objects::nonNull).flatMapMaybe(header -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.HEADER, header.getName());
            return ctx.getTemplateEngine().eval(header.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> new HttpHeader(header.getName(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, (Object)header.getValue()));
        }).toList().toMaybe();
    }

    private Maybe<List<HttpHeader>> evalListHeaderProperty(String name, List<HttpHeader> headers, String attributePrefix, DeploymentContext ctx) {
        if (headers == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(headers).filter(Objects::nonNull).flatMapMaybe(header -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.HEADER, header.getName());
            return ctx.getTemplateEngine().eval(header.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> new HttpHeader(header.getName(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, (Object)header.getValue()));
        }).toList().toMaybe();
    }

    private Maybe<Map<String, String>> evalMapStringProperty(String name, Map<String, String> value, String attributePrefix, BaseExecutionContext ctx) {
        Map attribute = (Map)ctx.getAttribute(this.buildAttributeName(attributePrefix, name));
        if (attribute != null) {
            value = attribute;
        }
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(value.entrySet()).filter(Objects::nonNull).flatMapMaybe(entry -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.GENERIC, (String)entry.getKey());
            return ctx.getTemplateEngine().eval((String)entry.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> Map.entry((String)entry.getKey(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, entry.getValue()));
        }).collect(() -> new HashMap(), (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue())).toMaybe();
    }

    private Maybe<Map<String, String>> evalMapStringProperty(String name, Map<String, String> value, String attributePrefix, DeploymentContext ctx) {
        if (value == null) {
            return Maybe.empty();
        }
        return Flowable.fromIterable(value.entrySet()).filter(Objects::nonNull).flatMapMaybe(entry -> {
            SecretFieldAccessControl accessControl = new SecretFieldAccessControl(true, FieldKind.GENERIC, (String)entry.getKey());
            return ctx.getTemplateEngine().eval((String)entry.getValue(), String.class).doOnSubscribe(d -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", (Object)accessControl)).doOnTerminate(() -> ctx.getTemplateEngine().getTemplateContext().setVariable("secret_field_access_control_var", null)).map(evaluatedValue -> Map.entry((String)entry.getKey(), evaluatedValue)).doOnError(throwable -> this.logger.error("Unable to evaluate property [{}] with expression [{}].", (Object)name, entry.getValue()));
        }).collect(() -> new HashMap(), (map, entry) -> map.put((String)entry.getKey(), (String)entry.getValue())).toMaybe();
    }

    private <T> void validateConfiguration(T configuration) {
        Set constraintViolations = validator.validate(configuration, new Class[0]);
        if (!constraintViolations.isEmpty()) {
            StringBuilder exceptionMessage = new StringBuilder(constraintViolations.size() + " constraint violations found : ");
            constraintViolations.forEach(violation -> exceptionMessage.append("[attribute[").append(violation.getPropertyPath()).append("] reason[").append(violation.getMessage()).append("]]"));
            this.logger.error(exceptionMessage.toString());
            throw new IllegalStateException(exceptionMessage.toString());
        }
    }

    public HttpProxyEndpointConnectorConfiguration evalNow(BaseExecutionContext ctx) {
        return (HttpProxyEndpointConnectorConfiguration)this.eval(ctx).blockingGet();
    }

    public HttpProxyEndpointConnectorConfiguration evalNow(DeploymentContext ctx) {
        return (HttpProxyEndpointConnectorConfiguration)this.eval(ctx).blockingGet();
    }

    public Single<HttpProxyEndpointConnectorConfiguration> eval(BaseExecutionContext ctx) {
        return this.eval(ctx, null);
    }

    public Single<HttpProxyEndpointConnectorConfiguration> eval(DeploymentContext ctx) {
        return this.eval(null, ctx);
    }

    private Single<HttpProxyEndpointConnectorConfiguration> eval(BaseExecutionContext baseExecutionContext, DeploymentContext deploymentContext) {
        HttpProxyEndpointConnectorConfiguration evaluatedConfiguration;
        if (baseExecutionContext != null) {
            if ("gravitee.attributes.endpoint.httpProxy".isEmpty()) {
                return Single.error((Throwable)new IllegalArgumentException("@ConfigurationEvaluator(attributePrefix=\"...\") is required when using BaseExecutionContext."));
            }
            HttpProxyEndpointConnectorConfiguration evaluatedConf = (HttpProxyEndpointConnectorConfiguration)baseExecutionContext.getInternalAttribute("httpProxyEndpointConnectorConfiguration-" + this.internalId);
            if (evaluatedConf != null) {
                return Single.just((Object)evaluatedConf);
            }
        }
        try {
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            evaluatedConfiguration = (HttpProxyEndpointConnectorConfiguration)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)this.configuration), HttpProxyEndpointConnectorConfiguration.class);
        }
        catch (JsonProcessingException e) {
            this.logger.error("Unable to clone configuration", (Throwable)e);
            return Single.error((Throwable)e);
        }
        String currentAttributePrefix = "gravitee.attributes.endpoint.httpProxy";
        ArrayList<Maybe> toEval = new ArrayList<Maybe>();
        ArrayList toEvalList = new ArrayList();
        ArrayList toEvalHeaderList = new ArrayList();
        ArrayList toEvalMap = new ArrayList();
        if (baseExecutionContext != null) {
            toEval.add(this.evalStringProperty("target", this.configuration.getTarget(), currentAttributePrefix, baseExecutionContext, "GENERIC").doOnSuccess(value -> evaluatedConfiguration.setTarget((String)value)));
        } else if (deploymentContext != null) {
            toEval.add(this.evalStringProperty("target", this.configuration.getTarget(), currentAttributePrefix, deploymentContext, "GENERIC").doOnSuccess(value -> evaluatedConfiguration.setTarget((String)value)));
        }
        Completable toEvalCompletable = Flowable.fromIterable(toEval).concatMapMaybe(m -> m).ignoreElements();
        Completable toEvalListCompletable = Flowable.fromIterable(toEvalList).concatMapMaybe(m -> m).ignoreElements();
        Completable toEvalHeaderListCompletable = Flowable.fromIterable(toEvalHeaderList).concatMapMaybe(m -> m).ignoreElements();
        Completable toEvalMapCompletable = Flowable.fromIterable(toEvalMap).concatMapMaybe(m -> m).ignoreElements();
        return Completable.concatArray((CompletableSource[])new CompletableSource[]{toEvalCompletable, toEvalListCompletable, toEvalHeaderListCompletable, toEvalMapCompletable}).andThen((CompletableSource)Completable.fromRunnable(() -> this.validateConfiguration(evaluatedConfiguration))).andThen((CompletableSource)Completable.fromRunnable(() -> {
            if (baseExecutionContext != null) {
                baseExecutionContext.setInternalAttribute("httpProxyEndpointConnectorConfiguration-" + this.internalId, (Object)evaluatedConfiguration);
            }
        })).onErrorResumeNext(t -> {
            if (baseExecutionContext != null && baseExecutionContext instanceof HttpPlainExecutionContext) {
                HttpPlainExecutionContext httpPlainExecutionContext = (HttpPlainExecutionContext)baseExecutionContext;
                return httpPlainExecutionContext.interruptWith(new ExecutionFailure(500).message("Invalid configuration").key(FAILURE_CONFIGURATION_INVALID));
            }
            return Completable.error((Throwable)t);
        }).toSingle(() -> evaluatedConfiguration);
    }

    static {
        ValidatorFactory factory = ((HibernateValidatorConfiguration)((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator())).buildValidatorFactory();
        validator = factory.getValidator();
    }
}

