/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.connector;

import io.gravitee.common.http.HttpHeader;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.common.util.URIUtils;
import io.gravitee.gateway.api.http.HttpHeaders;
import io.gravitee.gateway.http.utils.RequestUtils;
import io.gravitee.gateway.http.vertx.VertxHttpHeaders;
import io.gravitee.gateway.reactive.api.context.http.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.http.HttpRequest;
import io.gravitee.gateway.reactive.api.context.http.HttpResponse;
import io.gravitee.gateway.reactive.http.vertx.VertxHttpServerResponse;
import io.gravitee.node.api.opentelemetry.Span;
import io.gravitee.node.api.opentelemetry.http.ObservableHttpClientRequest;
import io.gravitee.node.api.opentelemetry.http.ObservableHttpClientResponse;
import io.gravitee.node.vertx.client.http.VertxHttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.client.HttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.client.UriHelper;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.connector.ProxyConnector;
import io.netty.buffer.ByteBuf;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.rxjava3.core.MultiMap;
import io.vertx.rxjava3.core.buffer.Buffer;
import io.vertx.rxjava3.core.http.HttpClientRequest;
import io.vertx.rxjava3.core.http.HttpClientResponse;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnector
implements ProxyConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpConnector.class);
    static final Set<CharSequence> HOP_HEADERS = Set.of("Connection", "Keep-Alive", "Proxy-Authorization", "Proxy-Authenticate", "Proxy-Connection", "TE", "Trailer", "Upgrade");
    private final String relativeTarget;
    protected final String defaultHost;
    protected final int defaultPort;
    private final boolean defaultSsl;
    private final MultiValueMap<String, String> targetParameters;
    protected final HttpProxyEndpointConnectorConfiguration configuration;
    protected final HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration;
    protected final HttpClientFactory httpClientFactory;

    public HttpConnector(HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration, HttpClientFactory httpClientFactory) {
        this.configuration = configuration;
        this.sharedConfiguration = sharedConfiguration;
        this.httpClientFactory = httpClientFactory;
        URL targetUrl = VertxHttpClientFactory.buildUrl((String)configuration.getTarget());
        this.relativeTarget = targetUrl.getPath();
        this.defaultHost = targetUrl.getHost();
        this.defaultPort = targetUrl.getPort() != -1 ? targetUrl.getPort() : targetUrl.getDefaultPort();
        this.defaultSsl = VertxHttpClientFactory.isSecureProtocol((String)targetUrl.getProtocol());
        this.targetParameters = targetUrl.getQuery() == null ? null : URIUtils.parameters((String)(UriHelper.URI_QUERY_DELIMITER_CHAR_SEQUENCE + targetUrl.getQuery()));
    }

    @Override
    public Completable connect(HttpExecutionContext ctx) {
        try {
            HttpRequest request = ctx.request();
            HttpResponse response = ctx.response();
            RequestOptions options = this.buildRequestOptions(ctx);
            String absoluteUri = VertxHttpClientFactory.toAbsoluteUri((RequestOptions)options, (String)this.defaultHost, (int)this.defaultPort);
            options.setAbsoluteURI(absoluteUri);
            ctx.metrics().setEndpoint(absoluteUri);
            ObservableHttpClientRequest observableHttpClientRequest = new ObservableHttpClientRequest(options);
            Span httpRequestSpan = ctx.getTracer().startSpanFrom((Object)observableHttpClientRequest);
            return this.httpClientFactory.getOrBuildHttpClient(ctx, this.configuration, this.sharedConfiguration).rxRequest(options).map(this::customizeHttpClientRequest).flatMap(httpClientRequest -> {
                observableHttpClientRequest.httpClientRequest(httpClientRequest.getDelegate());
                if (HttpConnector.requestWithBody(request)) {
                    return httpClientRequest.rxSend(request.chunks().map(buffer -> new Buffer(BufferImpl.buffer((ByteBuf)buffer.getNativeBuffer()))));
                }
                return httpClientRequest.rxSend();
            }).doOnSuccess(endpointResponse -> {
                response.status(endpointResponse.statusCode());
                this.copyHeaders(endpointResponse.headers(), response.headers());
                if (endpointResponse.version() == HttpVersion.HTTP_2) {
                    endpointResponse.customFrameHandler(frame -> ((VertxHttpServerResponse)response).getNativeResponse().writeCustomFrame(frame));
                }
                response.chunks(this.getEndpointResponseChunks((HttpClientResponse)endpointResponse, response, absoluteUri));
                ObservableHttpClientResponse observableHttpClientResponse = new ObservableHttpClientResponse(endpointResponse.getDelegate());
                ctx.getTracer().endWithResponse(httpRequestSpan, (Object)observableHttpClientResponse);
            }).doOnError(throwable -> ctx.getTracer().endOnError(httpRequestSpan, throwable)).ignoreElement();
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
    }

    @NonNull
    private Flowable<io.gravitee.gateway.api.buffer.Buffer> getEndpointResponseChunks(HttpClientResponse endpointResponse, HttpResponse response, String absoluteUri) {
        return endpointResponse.toFlowable().map(io.gravitee.gateway.api.buffer.Buffer::buffer).doOnComplete(() -> this.copyHeaders(endpointResponse.trailers(), response.trailers())).onErrorResumeNext(throwable -> {
            if (throwable instanceof StreamResetException) {
                log.debug("Stream reset to the backend [{}]", (Object)absoluteUri);
            } else {
                log.error("Exception occurred while handling response chunk from upstream [{}]", (Object)absoluteUri, throwable);
            }
            return Flowable.empty();
        }).doOnCancel(() -> {
            try {
                log.debug("Downstream request has been cancelled, cancelling upstream request to [{}]", (Object)absoluteUri);
                endpointResponse.request().reset();
            }
            catch (Exception e) {
                log.debug("Can't properly reset endpoint request to backend [{}]", (Object)absoluteUri, (Object)e);
            }
        });
    }

    protected HttpClientRequest customizeHttpClientRequest(HttpClientRequest httpClientRequest) {
        return httpClientRequest;
    }

    protected void copyHeaders(MultiMap sourceHeaders, HttpHeaders targetHeaders) {
        if (sourceHeaders != null && !sourceHeaders.isEmpty()) {
            if (targetHeaders instanceof VertxHttpHeaders) {
                ((VertxHttpHeaders)targetHeaders).getDelegate().addAll(sourceHeaders.getDelegate());
            } else {
                sourceHeaders.forEach(entry -> targetHeaders.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
            }
        }
    }

    protected RequestOptions buildRequestOptions(HttpExecutionContext ctx) {
        RequestOptions requestOptions = new RequestOptions();
        HttpRequest request = ctx.request();
        HttpHeaders requestHeaders = request.headers();
        String originalHost = request.originalHost();
        String currentRequestHost = request.host();
        for (CharSequence header2 : this.hopHeaders()) {
            requestHeaders.remove((CharSequence)header2.toString());
        }
        if (currentRequestHost != null && !Objects.equals(originalHost, currentRequestHost)) {
            requestHeaders.set((CharSequence)"Host", (CharSequence)currentRequestHost);
        } else {
            requestHeaders.remove((CharSequence)"Host");
        }
        if (!this.sharedConfiguration.getHttpOptions().isPropagateClientAcceptEncoding()) {
            requestHeaders.remove(io.vertx.core.http.HttpHeaders.ACCEPT_ENCODING);
        }
        this.prepareUriAndQueryParameters(ctx, requestOptions);
        List<HttpHeader> configHeaders = this.sharedConfiguration.getHeaders();
        if (configHeaders != null && !configHeaders.isEmpty()) {
            configHeaders.forEach(header -> requestHeaders.set((CharSequence)header.getName(), (CharSequence)header.getValue()));
        }
        if (requestHeaders instanceof VertxHttpHeaders) {
            requestOptions.setHeaders(((VertxHttpHeaders)requestHeaders).getDelegate());
        } else {
            HeadersMultiMap headers = new HeadersMultiMap();
            requestHeaders.names().forEach(arg_0 -> HttpConnector.lambda$buildRequestOptions$10((io.vertx.core.MultiMap)headers, requestHeaders, arg_0));
            requestOptions.setHeaders((io.vertx.core.MultiMap)headers);
        }
        return requestOptions.setMethod(HttpMethod.valueOf((String)request.method().name())).setTimeout(this.sharedConfiguration.getHttpOptions().getReadTimeout()).setFollowRedirects(Boolean.valueOf(this.sharedConfiguration.getHttpOptions().isFollowRedirects()));
    }

    protected Set<CharSequence> hopHeaders() {
        return HOP_HEADERS;
    }

    private void prepareUriAndQueryParameters(HttpExecutionContext ctx, RequestOptions requestOptions) {
        HttpRequest request = ctx.request();
        MultiValueMap requestParameters = request.parameters();
        this.addParameters((MultiValueMap<String, String>)requestParameters, this.targetParameters);
        String customEndpointTarget = (String)ctx.getAttribute("gravitee.attribute.request.endpoint");
        Object uri = this.relativeTarget;
        boolean isRelative = true;
        if (customEndpointTarget != null) {
            boolean endpointOverride = Boolean.TRUE.equals(ctx.getAttribute("gravitee.attribute.request.endpoint.override"));
            MultiValueMap customEndpointParameters = URIUtils.parameters((String)customEndpointTarget);
            if (!customEndpointParameters.isEmpty()) {
                customEndpointTarget = customEndpointTarget.substring(0, customEndpointTarget.indexOf(63));
                this.addParameters((MultiValueMap<String, String>)requestParameters, (MultiValueMap<String, String>)customEndpointParameters);
            }
            if (URIUtils.isAbsolute((String)customEndpointTarget)) {
                uri = customEndpointTarget;
                isRelative = false;
            } else {
                uri = endpointOverride ? customEndpointTarget : this.relativeTarget + customEndpointTarget;
            }
        } else {
            uri = (String)uri + request.pathInfo();
        }
        if (isRelative) {
            UriHelper.configureRelativeUri(requestOptions, (String)uri, (MultiValueMap<String, String>)requestParameters);
            requestOptions.setSsl(Boolean.valueOf(this.defaultSsl));
        } else {
            UriHelper.configureAbsoluteUri(requestOptions, (String)uri, (MultiValueMap<String, String>)requestParameters);
        }
    }

    private void addParameters(MultiValueMap<String, String> parameters, MultiValueMap<String, String> parametersToAdd) {
        if (parametersToAdd != null && !parametersToAdd.isEmpty()) {
            parametersToAdd.forEach((key, values) -> ((List)parameters.computeIfAbsent(key, k -> new ArrayList())).addAll(values));
        }
    }

    private static boolean requestWithBody(HttpRequest request) {
        return request.headers().contains("Transfer-Encoding") || request.headers().contains("Content-Length") || RequestUtils.hasStreamingContentType((HttpHeaders)request.headers());
    }

    private static /* synthetic */ void lambda$buildRequestOptions$10(io.vertx.core.MultiMap headers, HttpHeaders requestHeaders, String name) {
        headers.add(name, (Iterable)requestHeaders.getAll((CharSequence)name));
    }
}

