/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.client;

import io.gravitee.apim.common.mapper.HttpClientOptionsMapper;
import io.gravitee.apim.common.mapper.HttpProxyOptionsMapper;
import io.gravitee.apim.common.mapper.SslOptionsMapper;
import io.gravitee.gateway.reactive.api.context.http.HttpExecutionContext;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.node.vertx.client.http.VertxHttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.http.HttpClient;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpClientFactory {
    private HttpClient httpClient;
    private final AtomicBoolean httpClientCreated = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClient getOrBuildHttpClient(HttpExecutionContext ctx, HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        if (this.httpClient == null) {
            HttpClientFactory httpClientFactory = this;
            synchronized (httpClientFactory) {
                if (this.httpClientCreated.compareAndSet(false, true)) {
                    this.httpClient = this.buildHttpClient(ctx, configuration, sharedConfiguration).build().createHttpClient();
                }
            }
        }
        return this.httpClient;
    }

    protected VertxHttpClientFactory.VertxHttpClientFactoryBuilder buildHttpClient(HttpExecutionContext ctx, HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration) {
        return VertxHttpClientFactory.builder().vertx((Vertx)ctx.getComponent(Vertx.class)).nodeConfiguration((Configuration)ctx.getComponent(Configuration.class)).defaultTarget(configuration.getTarget()).httpOptions(HttpClientOptionsMapper.INSTANCE.map(sharedConfiguration.getHttpOptions())).sslOptions(SslOptionsMapper.INSTANCE.map(sharedConfiguration.getSslOptions())).proxyOptions(HttpProxyOptionsMapper.INSTANCE.map(sharedConfiguration.getProxyOptions()));
    }

    public void close() {
        if (this.httpClient != null) {
            this.httpClient.close();
            this.httpClient = null;
        }
    }
}

