/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.connector;

import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.http.HttpExecutionContext;
import io.gravitee.gateway.reactive.api.context.http.HttpRequest;
import io.gravitee.gateway.reactive.http.vertx.ws.VertxWebSocket;
import io.gravitee.node.api.opentelemetry.Span;
import io.gravitee.node.api.opentelemetry.http.ObservableHttpClientRequest;
import io.gravitee.plugin.endpoint.http.proxy.client.HttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.connector.HttpConnector;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.rxjava3.core.http.ServerWebSocket;
import io.vertx.rxjava3.core.http.WebSocket;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class WebSocketConnector
extends HttpConnector {
    static final Set<CharSequence> HOP_HEADERS = Set.of("Keep-Alive", "Proxy-Authorization", "Proxy-Authenticate", "Proxy-Connection", "TE", "Trailer");
    private static final String HTTP_PROXY_WEBSOCKET_UPGRADE_FAILURE = "HTTP_PROXY_WEBSOCKET_UPGRADE_FAILURE";
    private static final String HTTP_PROXY_WEBSOCKET_FAILURE = "HTTP_PROXY_WEBSOCKET_FAILURE";

    public WebSocketConnector(HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration, HttpClientFactory httpClient) {
        super(configuration, sharedConfiguration, httpClient);
    }

    @Override
    public Completable connect(HttpExecutionContext ctx) {
        try {
            HttpRequest request = ctx.request();
            RequestOptions options = this.buildRequestOptions(ctx);
            ObservableHttpClientRequest observableHttpClientRequest = new ObservableHttpClientRequest(options);
            Span httpRequestSpan = ctx.getTracer().startSpanFrom((Object)observableHttpClientRequest);
            ctx.metrics().setEndpoint(this.buildWebSocketUri(options));
            WebSocketConnectOptions webSocketConnectOptions = new WebSocketConnectOptions(options.toJson());
            if (request.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL)) {
                webSocketConnectOptions.setSubProtocols(this.parseSubProtocols(request));
            }
            return this.httpClientFactory.getOrBuildHttpClient(ctx, this.configuration, this.sharedConfiguration).rxWebSocket(webSocketConnectOptions).flatMap(endpointWebSocket -> {
                endpointWebSocket.pause();
                return request.webSocket().upgrade().doOnSuccess(requestWebSocket -> {
                    ServerWebSocket serverWebSocket = ((VertxWebSocket)requestWebSocket).getDelegate();
                    serverWebSocket.frameHandler(arg_0 -> ((WebSocket)endpointWebSocket).writeFrame(arg_0));
                    serverWebSocket.closeHandler(v -> endpointWebSocket.close());
                    endpointWebSocket.frameHandler(arg_0 -> ((ServerWebSocket)serverWebSocket).writeFrame(arg_0));
                    endpointWebSocket.closeHandler(v -> serverWebSocket.close());
                    endpointWebSocket.exceptionHandler(throwable -> serverWebSocket.close((short)400));
                    endpointWebSocket.resume();
                });
            }).ignoreElement().onErrorResumeNext(throwable -> {
                if (throwable instanceof UpgradeRejectedException) {
                    UpgradeRejectedException rejectedException = (UpgradeRejectedException)throwable;
                    return request.webSocket().close(rejectedException.getStatus()).andThen((CompletableSource)ctx.interruptWith(new ExecutionFailure(rejectedException.getStatus()).key(HTTP_PROXY_WEBSOCKET_UPGRADE_FAILURE).cause(throwable.getCause()).message(rejectedException.getMessage())));
                }
                return request.webSocket().close(500).andThen((CompletableSource)ctx.interruptWith(new ExecutionFailure(500).key(HTTP_PROXY_WEBSOCKET_FAILURE).cause(throwable).message("Endpoint Websocket connection in error")));
            }).doFinally(() -> ctx.getTracer().end(httpRequestSpan));
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    protected Set<CharSequence> hopHeaders() {
        return HOP_HEADERS;
    }

    private String buildWebSocketUri(RequestOptions options) {
        String protocol = options.isSsl() != false ? "wss" : "ws";
        return protocol + "://" + this.defaultHost + ":" + this.defaultPort + options.getURI();
    }

    private List<String> parseSubProtocols(HttpRequest request) {
        return request.headers().getAll((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL).stream().flatMap(header -> Arrays.stream(header.split(","))).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
    }
}

