/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy.connector;

import io.gravitee.gateway.reactive.api.ExecutionFailure;
import io.gravitee.gateway.reactive.api.context.ExecutionContext;
import io.gravitee.gateway.reactive.api.context.Request;
import io.gravitee.gateway.reactive.http.vertx.ws.VertxWebSocket;
import io.gravitee.plugin.endpoint.http.proxy.client.HttpClientFactory;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorSharedConfiguration;
import io.gravitee.plugin.endpoint.http.proxy.connector.HttpConnector;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.rxjava3.core.http.ServerWebSocket;
import io.vertx.rxjava3.core.http.WebSocket;
import java.util.Set;

public class WebSocketConnector
extends HttpConnector {
    static final Set<CharSequence> HOP_HEADERS = Set.of("Keep-Alive", "Proxy-Authorization", "Proxy-Authenticate", "Proxy-Connection", "TE", "Trailer");
    private static final String HTTP_PROXY_WEBSOCKET_UPGRADE_FAILURE = "HTTP_PROXY_WEBSOCKET_UPGRADE_FAILURE";
    private static final String HTTP_PROXY_WEBSOCKET_FAILURE = "HTTP_PROXY_WEBSOCKET_FAILURE";

    public WebSocketConnector(HttpProxyEndpointConnectorConfiguration configuration, HttpProxyEndpointConnectorSharedConfiguration sharedConfiguration, HttpClientFactory httpClient) {
        super(configuration, sharedConfiguration, httpClient);
    }

    @Override
    public Completable connect(ExecutionContext ctx) {
        try {
            Request request = ctx.request();
            RequestOptions options = this.buildRequestOptions(ctx);
            ctx.metrics().setEndpoint(options.getURI());
            WebSocketConnectOptions webSocketConnectOptions = new WebSocketConnectOptions(options.toJson());
            return this.httpClientFactory.getOrBuildHttpClient(ctx, this.configuration, this.sharedConfiguration).rxWebSocket(webSocketConnectOptions).flatMap(endpointWebSocket -> request.webSocket().upgrade().doOnSuccess(requestWebSocket -> {
                ServerWebSocket serverWebSocket = ((VertxWebSocket)requestWebSocket).getDelegate();
                serverWebSocket.frameHandler(arg_0 -> ((WebSocket)endpointWebSocket).writeFrame(arg_0));
                serverWebSocket.closeHandler(v -> endpointWebSocket.close());
                endpointWebSocket.frameHandler(arg_0 -> ((ServerWebSocket)serverWebSocket).writeFrame(arg_0));
                endpointWebSocket.closeHandler(v -> serverWebSocket.close());
                endpointWebSocket.exceptionHandler(throwable -> serverWebSocket.close((short)400));
            })).ignoreElement().onErrorResumeNext(throwable -> {
                if (throwable instanceof UpgradeRejectedException) {
                    UpgradeRejectedException rejectedException = (UpgradeRejectedException)throwable;
                    return request.webSocket().close(rejectedException.getStatus()).andThen((CompletableSource)ctx.interruptWith(new ExecutionFailure(rejectedException.getStatus()).key(HTTP_PROXY_WEBSOCKET_UPGRADE_FAILURE).message(rejectedException.getMessage())));
                }
                return request.webSocket().close(500).andThen((CompletableSource)ctx.interruptWith(new ExecutionFailure(500).key(HTTP_PROXY_WEBSOCKET_FAILURE).message("Endpoint Websocket connection in error")));
            });
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
    }

    @Override
    protected Set<CharSequence> hopHeaders() {
        return HOP_HEADERS;
    }
}

