/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.endpoint.http.proxy;

import io.gravitee.common.http.HttpHeader;
import io.gravitee.common.util.MultiValueMap;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.http.vertx.VertxHttpHeaders;
import io.gravitee.gateway.jupiter.api.ConnectorMode;
import io.gravitee.gateway.jupiter.api.connector.endpoint.sync.EndpointSyncConnector;
import io.gravitee.gateway.jupiter.api.context.ExecutionContext;
import io.gravitee.gateway.jupiter.api.context.Request;
import io.gravitee.gateway.jupiter.api.context.Response;
import io.gravitee.gateway.jupiter.http.vertx.client.VertxHttpClient;
import io.gravitee.node.api.configuration.Configuration;
import io.gravitee.plugin.endpoint.http.proxy.client.VertxHttpClientHelper;
import io.gravitee.plugin.endpoint.http.proxy.configuration.HttpProxyEndpointConnectorConfiguration;
import io.netty.buffer.ByteBuf;
import io.reactivex.rxjava3.core.Completable;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.rxjava3.core.Vertx;
import io.vertx.rxjava3.core.http.HttpClient;
import io.vertx.rxjava3.core.http.HttpClientResponse;
import io.vertx.rxjava3.core.http.HttpHeaders;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxyEndpointConnector
extends EndpointSyncConnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpProxyEndpointConnector.class);
    static final Set<CharSequence> HOP_HEADERS = Set.of("Connection", "Keep-Alive", "Proxy-Authorization", "Proxy-Authenticate", "Proxy-Connection", "TE", "Trailer", "Upgrade");
    private static final String ENDPOINT_ID = "http-proxy";
    static final Set<ConnectorMode> SUPPORTED_MODES = Set.of(ConnectorMode.REQUEST_RESPONSE);
    protected final HttpProxyEndpointConnectorConfiguration configuration;
    private final AtomicBoolean httpClientCreated = new AtomicBoolean(false);
    private final String relativeTarget;
    private HttpClient httpClient;

    public HttpProxyEndpointConnector(HttpProxyEndpointConnectorConfiguration configuration) {
        this.configuration = configuration;
        URL targetUrl = VertxHttpClient.buildUrl((String)configuration.getTarget());
        this.relativeTarget = targetUrl.getQuery() == null ? targetUrl.getPath() : targetUrl.getPath() + VertxHttpClientHelper.URI_QUERY_DELIMITER_CHAR_SEQUENCE + targetUrl.getQuery();
    }

    public String id() {
        return ENDPOINT_ID;
    }

    public Set<ConnectorMode> supportedModes() {
        return SUPPORTED_MODES;
    }

    public Completable connect(ExecutionContext ctx) {
        Request request = ctx.request();
        Response response = ctx.response();
        try {
            HttpClient client = this.getOrBuildHttpClient(ctx);
            RequestOptions options = this.buildRequestOptions(ctx);
            request.metrics().setEndpoint(options.getURI());
            return client.rxRequest(options).flatMap(httpClientRequest -> httpClientRequest.rxSend(request.chunks().map(buffer -> io.vertx.rxjava3.core.buffer.Buffer.buffer((ByteBuf)buffer.getNativeBuffer())))).doOnSuccess(endpointResponse -> {
                response.status(endpointResponse.statusCode());
                this.copyResponseHeaders(response, (HttpClientResponse)endpointResponse);
                response.chunks(endpointResponse.toFlowable().map(Buffer::buffer));
            }).ignoreElement();
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
    }

    protected void doStop() {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    private void copyResponseHeaders(Response response, HttpClientResponse endpointResponse) {
        io.gravitee.gateway.api.http.HttpHeaders responseHeaders = response.headers();
        if (responseHeaders instanceof VertxHttpHeaders) {
            ((VertxHttpHeaders)responseHeaders).getDelegate().addAll(endpointResponse.headers().getDelegate());
        } else {
            endpointResponse.headers().forEach(entry -> responseHeaders.add((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
        }
    }

    private RequestOptions buildRequestOptions(ExecutionContext ctx) {
        RequestOptions requestOptions = new RequestOptions();
        Request request = ctx.request();
        io.gravitee.gateway.api.http.HttpHeaders requestHeaders = request.headers();
        String originalHost = request.originalHost();
        String currentRequestHost = request.host();
        for (CharSequence header2 : HOP_HEADERS) {
            requestHeaders.remove((CharSequence)header2.toString());
        }
        if (currentRequestHost != null && !Objects.equals(originalHost, currentRequestHost)) {
            requestHeaders.set((CharSequence)"Host", (CharSequence)currentRequestHost);
        } else {
            requestHeaders.remove((CharSequence)"Host");
        }
        if (!this.configuration.getHttpOptions().isPropagateClientAcceptEncoding()) {
            requestHeaders.remove(HttpHeaders.ACCEPT_ENCODING);
        }
        VertxHttpClientHelper.configureAbsoluteUri(requestOptions, this.relativeTarget + request.pathInfo(), (MultiValueMap<String, String>)request.parameters());
        List<HttpHeader> configHeaders = this.configuration.getHeaders();
        if (configHeaders != null && !configHeaders.isEmpty()) {
            configHeaders.forEach(header -> requestHeaders.set((CharSequence)header.getName(), (CharSequence)header.getValue()));
        }
        if (requestHeaders instanceof VertxHttpHeaders) {
            requestOptions.setHeaders(((VertxHttpHeaders)requestHeaders).getDelegate());
        } else {
            HeadersMultiMap headers = new HeadersMultiMap();
            requestHeaders.names().forEach(arg_0 -> HttpProxyEndpointConnector.lambda$buildRequestOptions$5((MultiMap)headers, requestHeaders, arg_0));
            requestOptions.setHeaders((MultiMap)headers);
        }
        return requestOptions.setMethod(HttpMethod.valueOf((String)request.method().name())).setTimeout(this.configuration.getHttpOptions().getReadTimeout()).setFollowRedirects(Boolean.valueOf(this.configuration.getHttpOptions().isFollowRedirects()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient getOrBuildHttpClient(ExecutionContext ctx) throws MalformedURLException {
        if (this.httpClient == null) {
            HttpProxyEndpointConnector httpProxyEndpointConnector = this;
            synchronized (httpProxyEndpointConnector) {
                if (this.httpClientCreated.compareAndSet(false, true)) {
                    this.httpClient = VertxHttpClientHelper.buildHttpClient((Vertx)ctx.getComponent(Vertx.class), (Configuration)ctx.getComponent(Configuration.class), this.configuration, this.configuration.getTarget());
                }
            }
        }
        return this.httpClient;
    }

    private static /* synthetic */ void lambda$buildRequestOptions$5(MultiMap headers, io.gravitee.gateway.api.http.HttpHeaders requestHeaders, String name) {
        headers.add(name, (Iterable)requestHeaders.getAll((CharSequence)name));
    }
}

