/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.plugin.apiservice.internal;

import io.gravitee.plugin.apiservice.ApiServicePlugin;
import io.gravitee.plugin.apiservice.ApiServicePluginManager;
import io.gravitee.plugin.apiservice.internal.ApiServiceConfigurationClassFinder;
import io.gravitee.plugin.apiservice.internal.DefaultApiServicePlugin;
import io.gravitee.plugin.core.api.AbstractSimplePluginHandler;
import io.gravitee.plugin.core.api.Plugin;
import java.io.IOException;
import java.net.URLClassLoader;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiServicePluginHandler
extends AbstractSimplePluginHandler<ApiServicePlugin<?, ?>> {
    @Autowired
    private ApiServicePluginManager apiServicePluginManager;

    public boolean canHandle(Plugin plugin) {
        return "api-service".equalsIgnoreCase(plugin.type());
    }

    protected String type() {
        return "api-service";
    }

    protected ApiServicePlugin<?, ?> create(Plugin plugin, Class<?> pluginClass) {
        Class configurationClass = new ApiServiceConfigurationClassFinder().lookupFirst(pluginClass);
        return new DefaultApiServicePlugin(plugin, pluginClass, configurationClass);
    }

    protected void register(ApiServicePlugin<?, ?> apiServicePlugin) {
        this.apiServicePluginManager.register((Plugin)apiServicePlugin);
        ClassLoader connectorClassLoader = apiServicePlugin.connectorFactory().getClassLoader();
        if (connectorClassLoader instanceof URLClassLoader) {
            URLClassLoader classLoader = (URLClassLoader)connectorClassLoader;
            try {
                classLoader.close();
            }
            catch (IOException e) {
                this.logger.error("Unexpected exception while trying to release the api service plugin classloader", (Throwable)e);
            }
        }
    }

    protected ClassLoader getClassLoader(Plugin plugin) {
        return new URLClassLoader(plugin.dependencies(), ((Object)((Object)this)).getClass().getClassLoader());
    }

    @Generated
    public ApiServicePluginHandler(ApiServicePluginManager apiServicePluginManager) {
        this.apiServicePluginManager = apiServicePluginManager;
    }

    @Generated
    public ApiServicePluginHandler() {
    }
}

