/*
 * Decompiled with CFR 0.152.
 */
package com.android.base.image;

import androidx.annotation.NonNull;

public class ProgressInfo {
    private long currentBytes;
    private long contentLength;
    private long intervalTime;
    private long eachBytes;
    private long id;
    private boolean finish;

    public ProgressInfo(long id) {
        this.id = id;
    }

    public void setCurrentBytes(long currentBytes) {
        this.currentBytes = currentBytes;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public void setIntervalTime(long intervalTime) {
        this.intervalTime = intervalTime;
    }

    public void setEachBytes(long eachBytes) {
        this.eachBytes = eachBytes;
    }

    public void setFinish(boolean finish) {
        this.finish = finish;
    }

    public long getCurrentBytes() {
        return this.currentBytes;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getIntervalTime() {
        return this.intervalTime;
    }

    public long getEachBytes() {
        return this.eachBytes;
    }

    public long getId() {
        return this.id;
    }

    public boolean isFinished() {
        return this.finish;
    }

    public float getProgress() {
        if (this.getCurrentBytes() <= 0L || this.getContentLength() <= 0L) {
            return 0.0f;
        }
        return 1.0f * (float)this.getCurrentBytes() / (float)this.getContentLength();
    }

    public long getSpeed() {
        if (this.getEachBytes() <= 0L || this.getIntervalTime() <= 0L) {
            return 0L;
        }
        return this.getEachBytes() * 1000L / this.getIntervalTime();
    }

    @NonNull
    public String toString() {
        return "ProgressInfo{id=" + this.id + ", currentBytes=" + this.currentBytes + ", contentLength=" + this.contentLength + ", eachBytes=" + this.eachBytes + ", intervalTime=" + this.intervalTime + ", finish=" + this.finish + '}';
    }
}

