/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.searchbar.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

@RequiresApi(api=21)
public class LetterView
extends View {
    public List<String> letters;
    private Paint mPaint;
    private int selectPosition = -1;
    private int colorId = -65536;
    private OnLetterSelectListener listener;

    public LetterView(Context context) {
        this(context, null);
    }

    public LetterView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LetterView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public LetterView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initData();
    }

    private void initData() {
        this.letters = new ArrayList<String>();
        for (int i = 65; i < 91; ++i) {
            this.letters.add(String.format(Locale.CHINA, "%c", i));
        }
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-16777216);
        this.mPaint.setTextSize(32.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int size = this.letters.size();
        for (int i = 0; i < size; ++i) {
            float textWidth = this.mPaint.measureText(this.letters.get(i));
            int singleHeight = height / size;
            if (this.selectPosition == i) {
                this.mPaint.setColor(this.colorId);
            } else {
                this.mPaint.setColor(-16777216);
            }
            canvas.drawText(this.letters.get(i), ((float)width - textWidth) / 2.0f, (float)(singleHeight * (i + 1)), this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        float y = event.getY();
        int measuredHeight = this.getMeasuredHeight();
        int singleHeight = measuredHeight / this.letters.size();
        int position = (int)(y / (float)singleHeight);
        switch (event.getAction()) {
            case 2: {
                if (this.selectPosition == position || position >= this.letters.size() || position < 0) break;
                this.selectPosition = position;
                this.vibrate();
                if (this.listener != null) {
                    this.listener.onSelected(this.letters.get(position));
                }
                this.postInvalidate();
                break;
            }
            case 0: {
                if (position >= this.letters.size() || position < 0) break;
                this.selectPosition = position;
                this.vibrate();
                if (this.listener != null) {
                    this.listener.onSelected(this.letters.get(position));
                }
                this.postInvalidate();
                break;
            }
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        widthMeasureSpec = (int)this.mPaint.measureText("M") * 2;
        this.setMeasuredDimension(widthMeasureSpec, this.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    private void vibrate() {
        Vibrator vibrator = (Vibrator)this.getContext().getSystemService("vibrator");
        vibrator.vibrate(40L);
    }

    public void setOnLetterSelectListener(OnLetterSelectListener listener) {
        this.listener = listener;
    }

    public void setColorId(int colorId) {
        this.colorId = colorId;
    }

    public static interface OnLetterSelectListener {
        public void onSelected(String var1);
    }
}

