/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rectloadingview.animcontroller;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.LinearInterpolator;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.rectloadingview.RectLoadingView;

public class WaveAnimController
implements IAnimController<RectLoadingView> {
    private RectLoadingView view;
    private ValueAnimator[] animators;
    private int halfWaveCount = -1;
    private long delay;
    private boolean singleWave;
    private float minFraction = 0.1f;
    private float maxFraction = 1.0f;
    private boolean needCancel;

    public WaveAnimController() {
    }

    public WaveAnimController(int halfWaveCount) {
        this(halfWaveCount, false);
    }

    public WaveAnimController(boolean singleWave) {
        this(-1, singleWave);
    }

    public WaveAnimController(int halfWaveCount, boolean singleWave) {
        this.halfWaveCount = halfWaveCount;
        this.singleWave = singleWave;
    }

    public WaveAnimController(int halfWaveCount, boolean singleWave, float minFraction, float maxFraction) {
        this.halfWaveCount = halfWaveCount;
        this.singleWave = singleWave;
        this.minFraction = minFraction;
        this.maxFraction = maxFraction;
    }

    @Override
    public void createAnim(final RectLoadingView view) {
        this.view = view;
        this.delay = this.halfWaveCount < 0 ? view.getDuration() / (long)(view.getFractions().length - 1) : view.getDuration() / (long)this.halfWaveCount;
        this.animators = new ValueAnimator[view.getFractions().length];
        for (int i = 0; i < this.animators.length; ++i) {
            this.animators[i] = ValueAnimator.ofFloat((float[])new float[]{this.minFraction, this.maxFraction});
            this.animators[i].setDuration(view.getDuration());
            this.animators[i].setRepeatCount(this.singleWave ? 1 : -1);
            this.animators[i].setRepeatMode(2);
            this.animators[i].setInterpolator((TimeInterpolator)new LinearInterpolator());
            final int finalI = i;
            this.animators[i].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationRepeat(Animator animation) {
                    if (animation.getStartDelay() != 0L) {
                        WaveAnimController.this.animators[finalI].setStartDelay(0L);
                    }
                }
            });
            this.animators[i].addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    view.setFraction(finalI, ((Float)animation.getAnimatedValue()).floatValue());
                }
            });
            if (!this.singleWave || i != this.animators.length - 1) continue;
            this.animators[i].addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (!WaveAnimController.this.needCancel) {
                        WaveAnimController.this.startAnim();
                    }
                }
            });
        }
    }

    @Override
    public void startAnim() {
        this.needCancel = false;
        if (this.view != null) {
            float[] fractions = this.view.getFractions();
            for (int i = 0; i < fractions.length; ++i) {
                fractions[i] = this.minFraction;
            }
            this.view.setFractions(fractions);
        }
        if (this.animators != null) {
            for (int i = 0; i < this.animators.length; ++i) {
                if (this.animators[i] != null) {
                    this.animators[i].setStartDelay(this.delay * (long)i);
                }
                this.animators[i].start();
            }
        }
    }

    @Override
    public void stopAnim() {
        this.needCancel = true;
        if (this.animators != null) {
            for (int i = 0; i < this.animators.length; ++i) {
                if (this.animators[i] == null) continue;
                this.animators[i].cancel();
            }
        }
    }

    @Override
    public RectLoadingView getLoadingView() {
        return this.view;
    }
}

