/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.rectloadingview;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.xm.ui.widget.dialog.IAnimController;
import com.xm.ui.widget.rectloadingview.animcontroller.DefaultAnimController;
import com.xm.uilibrary.R;

public class RectLoadingView
extends View {
    private final float MAX_RECT_HEIGHT = this.dp2pxF(50.0f);
    private final float MIN_RECT_HEIGHT = this.dp2pxF(30.0f);
    private static final int DURATION = 1000;
    private static final int RECT_COUNT = 6;
    private static final int RECT_COLOR = -15485519;
    private float maxRectHeight;
    private float minRectHeight;
    private long duration;
    private int rectCount;
    private int rectColor;
    private boolean roundMode;
    private float deltaX;
    private float deltaY;
    private float rectWidth;
    private Paint mPaint;
    private RectF[] originrRects;
    private float[] fractions;
    private IAnimController animController;
    private RectF tempRectf = new RectF();

    public RectLoadingView(Context context) {
        this(context, null);
    }

    public RectLoadingView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RectLoadingView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.RectLoadingView);
        this.maxRectHeight = ta.getDimension(R.styleable.RectLoadingView_maxRectHeight, this.MAX_RECT_HEIGHT);
        this.minRectHeight = ta.getDimension(R.styleable.RectLoadingView_minRectHeight, this.MIN_RECT_HEIGHT);
        this.duration = ta.getInt(R.styleable.RectLoadingView_duartion, 1000);
        this.rectCount = ta.getInt(R.styleable.RectLoadingView_count, 6);
        this.rectColor = ta.getColor(R.styleable.RectLoadingView_color, -15485519);
        this.roundMode = ta.getBoolean(R.styleable.RectLoadingView_round_mode, true);
        ta.recycle();
        this.checkAttr();
        this.initPaint();
        this.animController = new DefaultAnimController();
    }

    private void checkAttr() {
        this.maxRectHeight = this.maxRectHeight < 0.0f ? this.MAX_RECT_HEIGHT : this.maxRectHeight;
        this.minRectHeight = this.minRectHeight < 0.0f ? this.MIN_RECT_HEIGHT : this.minRectHeight;
        this.duration = this.duration < 0L ? 1000L : this.duration;
        this.rectCount = this.rectCount < 0 ? 6 : this.rectCount;
    }

    private void initPaint() {
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.rectColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int wSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int hSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (wMode != 0x40000000) {
            wSize = this.dp2px(80.0f);
        }
        if (hMode != 0x40000000) {
            hSize = (int)(this.maxRectHeight + (float)this.dp2px(30.0f));
        }
        this.setMeasuredDimension(wSize, hSize);
    }

    private void initData() {
        this.deltaX = (float)this.getMeasuredWidth() * 1.0f / (float)(this.rectCount + 1);
        this.rectWidth = this.deltaX * 0.25f;
        if (this.rectCount < 3) {
            this.deltaY = 0.0f;
        } else {
            int tempCountY = this.rectCount % 2 != 0 ? (this.rectCount - 1) / 2 : (this.rectCount - 2) / 2;
            this.deltaY = (this.maxRectHeight - this.minRectHeight) / (float)tempCountY;
        }
        this.initFractions();
        this.originrRects = new RectF[this.rectCount];
        float centerY = (float)this.getMeasuredHeight() / 2.0f;
        for (int i = 0; i < this.originrRects.length; ++i) {
            float rectHeigt = (double)i < Math.ceil((float)this.rectCount / 2.0f) ? this.minRectHeight + this.deltaY * (float)i : this.minRectHeight + this.deltaY * (float)(this.rectCount - 1 - i);
            float left = this.deltaX * (float)(i + 1) - this.rectWidth / 2.0f;
            float right = this.deltaX * (float)(i + 1) + this.rectWidth / 2.0f;
            float top = centerY - rectHeigt / 2.0f;
            float bottom = centerY + rectHeigt / 2.0f;
            this.originrRects[i] = new RectF(left, top, right, bottom);
        }
        this.animController.stopAnim();
        this.animController.createAnim(this);
    }

    private void initFractions() {
        this.fractions = new float[this.rectCount];
        for (int i = 0; i < this.fractions.length; ++i) {
            this.fractions[i] = 1.0f;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.initData();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        this.drawRects(canvas);
        canvas.restore();
    }

    private void drawRects(Canvas canvas) {
        for (int i = 0; i < this.rectCount; ++i) {
            float deltaHeight = this.originrRects[i].height() - this.originrRects[i].height() * this.fractions[i];
            this.tempRectf.set(this.originrRects[i].left, this.originrRects[i].top + deltaHeight / 2.0f, this.originrRects[i].right, this.originrRects[i].bottom - deltaHeight / 2.0f);
            if (this.roundMode) {
                canvas.drawRoundRect(this.tempRectf, this.tempRectf.width() / 2.0f, this.tempRectf.width() / 2.0f, this.mPaint);
                continue;
            }
            canvas.drawRect(this.tempRectf, this.mPaint);
        }
    }

    protected void onDetachedFromWindow() {
        this.stopAnim(true);
        super.onDetachedFromWindow();
    }

    public void startAnim() {
        this.post(new Runnable(){

            @Override
            public void run() {
                RectLoadingView.this.animController.stopAnim();
                RectLoadingView.this.animController.startAnim();
            }
        });
    }

    public void stopAnim(final boolean reset) {
        this.post(new Runnable(){

            @Override
            public void run() {
                RectLoadingView.this.animController.stopAnim();
                if (reset) {
                    RectLoadingView.this.initFractions();
                    RectLoadingView.this.invalidate();
                }
            }
        });
    }

    public IAnimController getAnimController() {
        return this.animController;
    }

    public void setAnimController(IAnimController animController) {
        this.animController.stopAnim();
        this.animController = animController;
        this.initData();
    }

    public float[] getFractions() {
        return this.fractions;
    }

    public void setFractions(float[] fractions) {
        this.fractions = fractions;
        this.invalidate();
    }

    public void setFraction(int index, float fraction) {
        this.fractions[index] = fraction;
        this.invalidate();
    }

    public float getMaxRectHeight() {
        return this.maxRectHeight;
    }

    public void setMaxRectHeight(float maxRectHeight) {
        this.maxRectHeight = maxRectHeight;
        this.requestLayout();
    }

    public float getMinRectHeight() {
        return this.minRectHeight;
    }

    public void setMinRectHeight(float minRectHeight) {
        this.minRectHeight = minRectHeight;
        this.requestLayout();
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
        this.initData();
        this.invalidate();
    }

    public int getRectCount() {
        return this.rectCount;
    }

    public void setRectCount(int rectCount) {
        this.rectCount = rectCount;
        this.initData();
        this.invalidate();
    }

    public int getRectColor() {
        return this.rectColor;
    }

    public void setRectColor(int rectColor) {
        this.rectColor = rectColor;
        this.mPaint.setColor(rectColor);
        this.invalidate();
    }

    public boolean isRoundMode() {
        return this.roundMode;
    }

    public void setRoundMode(boolean roundMode) {
        this.roundMode = roundMode;
        this.invalidate();
    }

    private float dp2pxF(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int dp2px(float dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }
}

