/*
 * Decompiled with CFR 0.152.
 */
package com.xm.ui.widget.ptzview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.xm.ui.widget.drawgeometry.model.GeometryPoints;
import com.xm.ui.widget.drawgeometry.utils.GeometryUtils;
import com.xm.uilibrary.R;

public class PtzView
extends AppCompatImageView {
    private static final int TILT_UP = 0;
    private static final int TILT_DOWN = 1;
    private static final int PAN_LEFT = 2;
    private static final int PAN_RIGHT = 3;
    private static final int PAN_LEFTTOP = 4;
    private static final int PAN_LEFTDOWN = 5;
    private static final int PAN_RIGTHTOP = 6;
    private static final int PAN_RIGTHDOWN = 7;
    private static final int ZOOM_OUT = 8;
    private static final int ZOOM_IN = 9;
    private static final int FOCUS_FAR = 10;
    private static final int FOCUS_NEAR = 11;
    private static final int IRIS_OPEN = 12;
    private static final int IRIS_CLOSE = 13;
    private int normalBgSrcId;
    private int selectedUpBgSrcId;
    private int selectedDownBgSrcId;
    private int selectedLeftBgSrcId;
    private int selectedRightBgSrcId;
    private int centerPointColorId;
    private int bgWidth;
    private int bgHeight;
    private int centerPointRadius;
    private int widthMeasureSpec;
    private int heightMeasureSpec;
    private GeometryPoints circlePoints;
    private GeometryPoints centerPoints;
    private Paint paint;
    private int ptzDirection;
    private int maxDistance;
    private boolean isOnlyHorizontal;
    private boolean isOnlyVertically;
    private OnPtzViewListener ptzViewListener;

    public PtzView(Context context) {
        this(context, null);
    }

    public PtzView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PtzView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PtzView);
        if (typedArray == null) {
            return;
        }
        this.normalBgSrcId = typedArray.getResourceId(R.styleable.PtzView_NormalBgSrc, 0);
        this.selectedUpBgSrcId = typedArray.getResourceId(R.styleable.PtzView_SelectedUpBgSrc, 0);
        this.selectedDownBgSrcId = typedArray.getResourceId(R.styleable.PtzView_SelectedDownBgSrc, 0);
        this.selectedLeftBgSrcId = typedArray.getResourceId(R.styleable.PtzView_SelectedLeftBgSrc, 0);
        this.selectedRightBgSrcId = typedArray.getResourceId(R.styleable.PtzView_SelectedRightBgSrc, 0);
        this.centerPointColorId = typedArray.getColor(R.styleable.PtzView_CenterPointColor, this.getResources().getColor(R.color.theme_color));
        this.isOnlyHorizontal = typedArray.getBoolean(R.styleable.PtzView_OnlyHorizontal, false);
        this.isOnlyVertically = typedArray.getBoolean(R.styleable.PtzView_OnlyVertically, false);
        typedArray.recycle();
        if (this.normalBgSrcId != 0) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.normalBgSrcId);
            if (bitmap != null) {
                this.bgWidth = bitmap.getWidth();
                this.bgHeight = bitmap.getHeight();
                bitmap.recycle();
                bitmap = null;
            }
            this.setImageResource(this.normalBgSrcId);
        }
        this.paint = new Paint();
        this.paint.setColor(this.centerPointColorId);
        this.paint.setAntiAlias(true);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawCircle(this.circlePoints.x, this.circlePoints.y, (float)this.centerPointRadius, this.paint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.widthMeasureSpec = widthMeasureSpec;
        this.heightMeasureSpec = heightMeasureSpec;
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed && this.getWidth() > 0 && this.getHeight() > 0) {
            if (this.getWidth() > this.getHeight()) {
                this.bgWidth = this.getHeight();
                this.bgHeight = this.getHeight();
                this.setMeasuredDimension(this.measureWidth(this.widthMeasureSpec), this.measureHeight(this.heightMeasureSpec));
            } else if (this.getWidth() < this.getHeight()) {
                this.bgWidth = this.getWidth();
                this.bgHeight = this.getWidth();
                this.setMeasuredDimension(this.measureWidth(this.widthMeasureSpec), this.measureHeight(this.heightMeasureSpec));
            }
        }
        this.centerPointRadius = this.bgWidth / 8;
        this.maxDistance = this.bgWidth / 2 - this.centerPointRadius;
        this.circlePoints = new GeometryPoints(this.getWidth() / 2, this.getHeight() / 2);
        this.centerPoints = new GeometryPoints(this.getWidth() / 2, this.getHeight() / 2);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private int measureWidth(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.bgWidth + this.getPaddingLeft() + this.getPaddingRight();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int measureHeight(int measureSpec) {
        int result = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.bgHeight + this.getPaddingTop() + this.getPaddingBottom();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.dealWithFinger(new GeometryPoints(event.getX(), event.getY()));
                this.dealWithPointDirection(this.circlePoints);
                break;
            }
            case 2: {
                this.dealWithFinger(new GeometryPoints(event.getX(), event.getY()));
                this.dealWithPointDirection(this.circlePoints);
                break;
            }
            case 1: 
            case 3: {
                this.dealWithFinger(new GeometryPoints(this.getWidth() / 2, this.getHeight() / 2));
                this.setImageResource(this.normalBgSrcId);
                if (this.ptzViewListener == null) break;
                this.ptzViewListener.onPtzDirection(this.ptzDirection, true);
                break;
            }
        }
        return true;
    }

    private void dealWithFinger(GeometryPoints point) {
        if (point == null) {
            return;
        }
        try {
            int distance = (int)Math.sqrt(Math.pow(point.x - this.centerPoints.x, 2.0) + Math.pow(point.y - this.centerPoints.y, 2.0));
            float angle = (float)GeometryUtils.getAngle(point.x - this.centerPoints.x, point.y - this.centerPoints.y);
            this.circlePoints = distance > this.maxDistance ? GeometryUtils.getSameAngleDifferRadius(angle, this.maxDistance, this.centerPoints) : point.clone();
            this.invalidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void dealWithPointDirection(GeometryPoints points) {
        if (points == null) {
            return;
        }
        int distance = (int)Math.sqrt(Math.pow(points.x - this.centerPoints.x, 2.0) + Math.pow(points.y - this.centerPoints.y, 2.0));
        if (distance <= this.centerPointRadius) {
            return;
        }
        float angle = (float)GeometryUtils.getAngle(points.x - this.centerPoints.x, points.y - this.centerPoints.y);
        points = GeometryUtils.getSameAngleDifferRadius((angle - 45.0f) % 360.0f, (float)Math.hypot(points.x - this.centerPoints.x, points.y - this.centerPoints.y), this.centerPoints);
        float x = points.x - this.centerPoints.x;
        float y = points.y - this.centerPoints.y;
        if (x >= 0.0f && y >= 0.0f) {
            if (!this.isOnlyHorizontal || this.isOnlyVertically) {
                this.ptzDirection = 1;
                this.setImageResource(this.selectedDownBgSrcId);
            }
        } else if (x >= 0.0f && y < 0.0f) {
            if (!this.isOnlyVertically || this.isOnlyHorizontal) {
                this.ptzDirection = 2;
                this.setImageResource(this.selectedRightBgSrcId);
            }
        } else if (x < 0.0f && y < 0.0f) {
            if (!this.isOnlyHorizontal || this.isOnlyVertically) {
                this.ptzDirection = 0;
                this.setImageResource(this.selectedUpBgSrcId);
            }
        } else if (x < 0.0f && y >= 0.0f && (!this.isOnlyVertically || this.isOnlyHorizontal)) {
            this.ptzDirection = 3;
            this.setImageResource(this.selectedLeftBgSrcId);
        }
        if (this.ptzViewListener != null) {
            this.ptzViewListener.onPtzDirection(this.ptzDirection, false);
        }
    }

    public void setOnlyHorizontal(boolean onlyHorizontal) {
        this.isOnlyHorizontal = onlyHorizontal;
    }

    public void setOnlyVertically(boolean onlyVertically) {
        this.isOnlyVertically = onlyVertically;
    }

    public void setSelectedDownBgSrcId(int selectedDownBgSrcId) {
        this.selectedDownBgSrcId = selectedDownBgSrcId;
    }

    public void setSelectedUpBgSrcId(int selectedUpBgSrcId) {
        this.selectedUpBgSrcId = selectedUpBgSrcId;
    }

    public void setSelectedLeftBgSrcId(int selectedLeftBgSrcId) {
        this.selectedLeftBgSrcId = selectedLeftBgSrcId;
    }

    public void setSelectedRightBgSrcId(int selectedRightBgSrcId) {
        this.selectedRightBgSrcId = selectedRightBgSrcId;
    }

    public void setNormalBgSrcId(int normalBgSrcId) {
        this.normalBgSrcId = normalBgSrcId;
        this.setImageResource(normalBgSrcId);
    }

    public void setOnPtzViewListener(OnPtzViewListener listener) {
        this.ptzViewListener = listener;
    }

    public static interface OnPtzViewListener {
        public void onPtzDirection(int var1, boolean var2);
    }
}

